/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import java.util.Collections;

@zzgk
public class zzd
extends zzfe.zza
implements zzo {
    static final int zzAu = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    private final zzcd zzAv;
    private final zzcc zzAw;
    AdOverlayInfoParcel zzAx;
    zzk zzAy;
    zzip zzoL;
    zzc zzAz;
    zzm zzAA;
    boolean zzAB = false;
    FrameLayout zzAC;
    WebChromeClient.CustomViewCallback zzAD;
    boolean zzAE = false;
    boolean zzAF = false;
    RelativeLayout zzzA;
    boolean zzAG = false;
    int zzAH = 0;
    private boolean zzAI;
    private boolean zzAJ = false;
    private boolean zzAK = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzAv = new zzcd(zzby.zzuB.get(), "show_interstitial", "interstitial");
        this.zzAw = this.zzAv.zzdl();
    }

    public void close() {
        this.zzAH = 2;
        this.mActivity.finish();
    }

    public zzk zzew() {
        return this.zzAy;
    }

    public void zzex() {
        if (this.zzAx != null && this.zzAB) {
            this.setRequestedOrientation(this.zzAx.orientation);
        }
        if (this.zzAC != null) {
            this.mActivity.setContentView((View)this.zzzA);
            this.zzaE();
            this.zzAC.removeAllViews();
            this.zzAC = null;
        }
        if (this.zzAD != null) {
            this.zzAD.onCustomViewHidden();
            this.zzAD = null;
        }
        this.zzAB = false;
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (this.zzAy != null) {
            this.zzAy.zze(n, n2, n3, n4);
        }
    }

    public void zza(int n, int n2, int n3, int n4, int n5) {
        this.zzAv.zza(this.zzAw, "vpr");
        zzcc zzcc2 = this.zzAv.zzdl();
        if (this.zzAy == null) {
            this.zzAy = new zzk((Context)this.mActivity, this.zzoL, n5, this.zzAv, zzcc2);
            this.zzzA.addView((View)this.zzAy, 0, new ViewGroup.LayoutParams(-1, -1));
            this.zzAy.zze(n, n2, n3, n4);
            this.zzoL.zzgS().zzF(false);
        }
    }

    @Override
    public void zzey() {
        this.zzAH = 1;
        this.mActivity.finish();
    }

    @Override
    public void onBackPressed() {
        this.zzAH = 0;
    }

    @Override
    public boolean zzez() {
        this.zzAH = 0;
        if (this.zzoL == null) {
            return true;
        }
        boolean bl = this.zzoL.zzgY();
        if (!bl) {
            this.zzoL.zzc("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzAE = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzAx = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzAx == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzAx.zzqb.zzIB > 7500000) {
                this.zzAH = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzAK = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzAF = this.zzAx.zzBa != null ? this.zzAx.zzBa.zzpk : false;
            if (savedInstanceState == null) {
                if (this.zzAx.zzAQ != null && this.zzAK) {
                    this.zzAx.zzAQ.zzaW();
                }
                if (this.zzAx.zzAX != 1 && this.zzAx.zzAP != null) {
                    this.zzAx.zzAP.onAdClicked();
                }
            }
            this.zzzA = new zzb((Context)this.mActivity, this.zzAx.zzAZ);
            switch (this.zzAx.zzAX) {
                case 1: {
                    this.zzv(false);
                    break;
                }
                case 2: {
                    this.zzAz = new zzc(this.zzAx.zzAR);
                    this.zzv(false);
                    break;
                }
                case 3: {
                    this.zzv(true);
                    break;
                }
                case 4: {
                    if (this.zzAE) {
                        this.zzAH = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzp.zzbu().zza((Context)this.mActivity, this.zzAx.zzAO, this.zzAx.zzAW)) {
                        this.zzAH = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE(zza2.getMessage());
            this.zzAH = 3;
            this.mActivity.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zzAx != null && this.zzAx.zzAX == 4) {
            if (this.zzAE) {
                this.zzAH = 3;
                this.mActivity.finish();
            } else {
                this.zzAE = true;
            }
        }
        if (this.zzoL != null && !this.zzoL.isDestroyed()) {
            zzp.zzbz().zzb(this.zzoL.getWebView());
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("The webview does not exit. Ignoring action.");
        }
    }

    @Override
    public void onPause() {
        if (this.zzAy != null) {
            this.zzAy.pause();
        }
        this.zzex();
        if (!(this.zzoL == null || this.mActivity.isFinishing() && this.zzAz != null)) {
            zzp.zzbz().zza(this.zzoL.getWebView());
        }
        this.zzeB();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzAE);
    }

    @Override
    public void onStop() {
        this.zzeB();
    }

    @Override
    public void onDestroy() {
        if (this.zzAy != null) {
            this.zzAy.destroy();
        }
        if (this.zzoL != null) {
            this.zzzA.removeView((View)this.zzoL.getWebView());
        }
        this.zzeB();
    }

    public void zzu(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzAA = new zzm((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzAA.zza(bl, this.zzAx.zzAU);
        this.zzzA.addView((View)this.zzAA, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzaE() {
        this.zzAI = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzAA != null) {
            this.zzAA.zza(bl, bl2);
        }
    }

    public void zzeA() {
        this.zzzA.removeView((View)this.zzAA);
        this.zzu(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.mActivity.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzAC = new FrameLayout((Context)this.mActivity);
        this.zzAC.setBackgroundColor(-16777216);
        this.zzAC.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzAC);
        this.zzaE();
        this.zzAD = customViewCallback;
        this.zzAB = true;
    }

    protected void zzv(boolean bl) throws zza {
        Window window;
        if (!this.zzAI) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzAF || this.zzAx.zzBa != null && this.zzAx.zzBa.zzpl) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzAx.zzAR.zzgS().zzbY();
        this.zzAG = false;
        if (bl2) {
            if (this.zzAx.orientation == zzp.zzbz().zzgv()) {
                this.zzAG = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzAx.orientation == zzp.zzbz().zzgw()) {
                this.zzAG = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaC("Delay onShow to next orientation change: " + this.zzAG);
        this.setRequestedOrientation(this.zzAx.orientation);
        if (zzp.zzbz().zza(window)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzAF) {
            this.zzzA.setBackgroundColor(-16777216);
        } else {
            this.zzzA.setBackgroundColor(zzAu);
        }
        this.mActivity.setContentView((View)this.zzzA);
        this.zzaE();
        if (bl) {
            this.zzoL = zzp.zzby().zza((Context)this.mActivity, this.zzAx.zzAR.zzaN(), true, bl2, null, this.zzAx.zzqb);
            this.zzoL.zzgS().zzb(null, null, this.zzAx.zzAS, this.zzAx.zzAW, true, this.zzAx.zzAY, null, this.zzAx.zzAR.zzgS().zzhb(), null);
            this.zzoL.zzgS().zza(new zziq.zza(){

                @Override
                public void zza(zzip zzip2, boolean bl) {
                    zzip2.zzeD();
                }
            });
            if (this.zzAx.url != null) {
                this.zzoL.loadUrl(this.zzAx.url);
            } else if (this.zzAx.zzAV != null) {
                this.zzoL.loadDataWithBaseURL(this.zzAx.zzAT, this.zzAx.zzAV, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzAx.zzAR != null) {
                this.zzAx.zzAR.zzb(this);
            }
        } else {
            this.zzoL = this.zzAx.zzAR;
            this.zzoL.setContext((Context)this.mActivity);
        }
        this.zzoL.zza(this);
        ViewParent viewParent = this.zzoL.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.zzoL.getWebView());
        }
        if (this.zzAF) {
            this.zzoL.setBackgroundColor(zzAu);
        }
        this.zzzA.addView((View)this.zzoL.getWebView(), -1, -1);
        if (!bl && !this.zzAG) {
            this.zzeD();
        }
        this.zzu(bl2);
        if (this.zzoL.zzgT()) {
            this.zza(bl2, true);
        }
    }

    protected void zzeB() {
        if (!this.mActivity.isFinishing() || this.zzAJ) {
            return;
        }
        this.zzAJ = true;
        if (zzp.zzbA().zzgc() != null) {
            zzp.zzbA().zzgc().zza(this.zzAv);
        }
        if (this.zzoL != null) {
            this.zzv(this.zzAH);
            this.zzzA.removeView((View)this.zzoL.getWebView());
            if (this.zzAz != null) {
                this.zzoL.setContext(this.zzAz.context);
                this.zzoL.zzC(false);
                this.zzAz.zzAN.addView((View)this.zzoL.getWebView(), this.zzAz.index, this.zzAz.zzAM);
                this.zzAz = null;
            }
            this.zzoL = null;
        }
        if (this.zzAx != null && this.zzAx.zzAQ != null) {
            this.zzAx.zzAQ.zzaV();
        }
    }

    public void zzeC() {
        if (this.zzAG) {
            this.zzAG = false;
            this.zzeD();
        }
    }

    protected void zzeD() {
        this.zzoL.zzeD();
    }

    protected void zzv(int n) {
        this.zzoL.zzv(n);
    }

    @zzgk
    static final class zzb
    extends RelativeLayout {
        zzhw zzqF;

        public zzb(Context context, String string) {
            super(context);
            this.zzqF = new zzhw(context, string);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzqF.zze(event);
            return false;
        }
    }

    @zzgk
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzAM;
        public final ViewGroup zzAN;
        public final Context context;

        public zzc(zzip zzip2) throws zza {
            this.zzAM = zzip2.getLayoutParams();
            ViewParent viewParent = zzip2.getParent();
            this.context = zzip2.zzgO();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzAN = (ViewGroup)viewParent;
            this.index = this.zzAN.indexOfChild((View)zzip2.getWebView());
            this.zzAN.removeView((View)zzip2.getWebView());
            zzip2.zzC(true);
        }
    }

    @zzgk
    private static final class zza
    extends Exception {
        public zza(String string) {
            super(string);
        }
    }
}

