/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzd;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzo;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzx;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzcz;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzeg;

public class AdLoader {
    private final zzg zznK;
    private final Context mContext;
    private final zzo zznL;

    AdLoader(Context context, zzo adLoader) {
        this(context, adLoader, zzg.zzcA());
    }

    AdLoader(Context context, zzo adLoader, zzg parcelFactory) {
        this.mContext = context;
        this.zznL = adLoader;
        this.zznK = parcelFactory;
    }

    private void zza(zzx zzx2) {
        try {
            this.zznL.zze(this.zznK.zza(this.mContext, zzx2));
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Failed to load ad.", remoteException);
        }
    }

    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzaF());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzaF());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zznL.getMediationAdapterClassName();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zznL.isLoading();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzp zznM;

        public Builder(Context context, String adUnitID) {
            this(context, zzd.zza(context, adUnitID, new zzeg()));
        }

        Builder(Context context, zzp builder) {
            this.mContext = context;
            this.zznM = builder;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener listener) {
            try {
                this.zznM.zza(new zzcz(listener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener listener) {
            try {
                this.zznM.zza(new zzcy(listener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String templateId, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            try {
                this.zznM.zza(templateId, new zzdb(adLoadedListener), customClickListener == null ? null : new zzda(customClickListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener listener) {
            try {
                this.zznM.zzb(new zzc(listener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions options) {
            try {
                this.zznM.zza(new NativeAdOptionsParcel(options));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zznM.zzbk());
            }
            catch (RemoteException remoteException) {
                zzb.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

