/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzpc = new Object();
    private final zzm zzUV;
    private final zza zzUW = new zza();
    private OnPreloadStatusUpdatedListener zzUX;
    private OnQueueStatusUpdatedListener zzUY;
    private OnMetadataUpdatedListener zzUZ;
    private OnStatusUpdatedListener zzVa;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this.zzUV = new zzm(null){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            protected void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            protected void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }
        };
        this.zzUV.zza(this.zzUW);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition, JSONObject customData) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, customData);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final long[] activeTrackIds, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, mediaInfo, autoplay, playPosition, activeTrackIds, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zzb(this.zzVC, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zzc(this.zzVC, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, volume, customData);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, muteState, customData);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        if (trackIds == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, trackIds);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        if (trackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient apiClient, final MediaQueueItem[] items, final int startIndex, final int repeatMode, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, items, startIndex, repeatMode, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient apiClient, final MediaQueueItem[] itemsToInsert, final int insertBeforeItemId, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, itemsToInsert, insertBeforeItemId, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient apiClient, MediaQueueItem item, JSONObject customData) throws IllegalArgumentException {
        return this.queueInsertItems(apiClient, new MediaQueueItem[]{item}, 0, customData);
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient apiClient, final MediaQueueItem[] itemsToUpdate, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, 0, itemsToUpdate, 0, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient apiClient, final int[] itemIdsToRemove, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, itemIdsToRemove, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient apiClient, final int[] itemIdsToReorder, final int insertBeforeItemId, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, itemIdsToReorder, insertBeforeItemId, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, 0, null, -1, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, 0, null, 1, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient apiClient, final int repeatMode, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, 0, null, 0, repeatMode, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient apiClient, final int itemId, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzaP(itemId) == -1) {
                        this.zza(this.zzs(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, new int[]{itemId}, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient apiClient, final int itemId, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzaP(itemId) == -1) {
                        this.zza(this.zzs(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, itemId, null, 0, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient apiClient, final int itemId, final int newIndex, final JSONObject customData) {
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpc;
                synchronized (object) {
                    int n = RemoteMediaPlayer.this.zzaP(itemId);
                    if (n == -1) {
                        this.zza(this.zzs(new Status(0)));
                        return;
                    }
                    if (newIndex < 0) {
                        this.zza(this.zzs(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", newIndex))));
                        return;
                    }
                    if (n == newIndex) {
                        this.zza(this.zzs(new Status(0)));
                        return;
                    }
                    int n2 = newIndex > n ? newIndex + 1 : newIndex;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n2);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.zzUW.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzUV.zza(this.zzVC, new int[]{itemId}, n3, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzs(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzUW.zzb(null);
                    }
                }
            }
        });
    }

    private int zzaP(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzUV.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzUV.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzUV.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzUV.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.zzVa = listener;
    }

    private void onStatusUpdated() {
        if (this.zzVa != null) {
            this.zzVa.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.zzUZ = listener;
    }

    private void onMetadataUpdated() {
        if (this.zzUZ != null) {
            this.zzUZ.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener listener) {
        this.zzUY = listener;
    }

    private void onQueueStatusUpdated() {
        if (this.zzUY != null) {
            this.zzUY.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener listener) {
        this.zzUX = listener;
    }

    private void onPreloadStatusUpdated() {
        if (this.zzUX != null) {
            this.zzUX.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.zzUV.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.zzUV.zzbJ(message);
    }

    private static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzo zzVC = new zzo(){

            @Override
            public void zzy(long l) {
                zzb.this.zza(zzb.this.zzs(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zza(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzs(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzs(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzQA;
        private final JSONObject zzUl;

        zzc(Status status, JSONObject jSONObject) {
            this.zzQA = status;
            this.zzUl = jSONObject;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzUl;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzn {
        private GoogleApiClient zzVy;
        private long zzVz = 0L;

        public void zzb(GoogleApiClient googleApiClient) {
            this.zzVy = googleApiClient;
        }

        @Override
        public long zzme() {
            return ++this.zzVz;
        }

        @Override
        public void zza(String string, String string2, long l, String string3) throws IOException {
            if (this.zzVy == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzVy, string, string2).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzVA;

            zza(long l) {
                this.zzVA = l;
            }

            public void zzr(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzUV.zzb(this.zzVA, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzr((Status)x0);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

