/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int mVersionCode;
    private final String zzatL;
    private final long zzayN;
    private final long zzayO;
    private final byte[] zzayP;
    private final int mState;
    private final String zzasD;

    public MilestoneEntity(Milestone milestone) {
        this.mVersionCode = 4;
        this.zzatL = milestone.getMilestoneId();
        this.zzayN = milestone.getCurrentProgress();
        this.zzayO = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzasD = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzayP = null;
        } else {
            this.zzayP = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzayP, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.mVersionCode = versionCode;
        this.zzatL = milestoneId;
        this.zzayN = currentProgress;
        this.zzayO = targetProgress;
        this.zzayP = completionBlob;
        this.mState = state;
        this.zzasD = eventId;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzasD;
    }

    @Override
    public String getMilestoneId() {
        return this.zzatL;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzayN;
    }

    @Override
    public long getTargetProgress() {
        return this.zzayO;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzayP;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzw.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.zza(this, obj);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzw.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzw.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzw.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzw.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzw.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzw.zzu((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.zza(this, out, flags);
    }
}

