/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzln;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzaxy;
    private final String zzaxz;
    private final String zzaxA;
    private final long zzaxB;
    private final long zzaxC;
    private final String zzaxD;
    private final Uri zzaxE;
    private final Uri zzaxF;
    private final PlayerEntity zzaxG;
    private final String zzaxH;
    private final String zzaxI;
    private final String zzaxJ;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzaxy = score.getRank();
        this.zzaxz = (String)zzx.zzv((Object)score.getDisplayRank());
        this.zzaxA = (String)zzx.zzv((Object)score.getDisplayScore());
        this.zzaxB = score.getRawScore();
        this.zzaxC = score.getTimestampMillis();
        this.zzaxD = score.getScoreHolderDisplayName();
        this.zzaxE = score.getScoreHolderIconImageUri();
        this.zzaxF = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzaxG = player == null ? null : (PlayerEntity)player.freeze();
        this.zzaxH = score.getScoreTag();
        this.zzaxI = score.getScoreHolderIconImageUrl();
        this.zzaxJ = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzaxy;
    }

    @Override
    public String getDisplayRank() {
        return this.zzaxz;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaxz, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzaxA;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaxA, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzaxB;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzaxC;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzaxG == null) {
            return this.zzaxD;
        }
        return this.zzaxG.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaxG == null) {
            zzln.zzb((String)this.zzaxD, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaxG.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzaxG == null) {
            return this.zzaxE;
        }
        return this.zzaxG.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzaxG == null) {
            return this.zzaxI;
        }
        return this.zzaxG.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzaxG == null) {
            return this.zzaxF;
        }
        return this.zzaxG.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzaxG == null) {
            return this.zzaxJ;
        }
        return this.zzaxG.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzaxG;
    }

    @Override
    public String getScoreTag() {
        return this.zzaxH;
    }

    public LeaderboardScore zzuS() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzw.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzw.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzw.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzw.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzw.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzw.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzw.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzw.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzw.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzw.zzu((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzuS();
    }
}

