/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.request.SensorRequest;
import com.google.android.gms.fitness.request.zzs;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.location.LocationRequest;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SensorRegistrationRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzanm;
    private final DataType zzanl;
    private zzj zzaqi;
    int zzaqj;
    int zzaqk;
    private final long zzaoE;
    private final long zzaql;
    private final PendingIntent mPendingIntent;
    private final long zzaqm;
    private final int zzaoF;
    private final List<LocationRequest> zzaqn;
    private final long zzaqo;
    private final List<Object> zzaqp;
    private final zznh zzapE;
    private final String zzOZ;
    public static final Parcelable.Creator<SensorRegistrationRequest> CREATOR = new zzs();

    SensorRegistrationRequest(int versionCode, DataSource dataSource, DataType dataType, IBinder listenerBinder, int samplingIntervalMicrosInt, int maxDeliveryLatencyMicrosInt, long samplingIntervalMicros, long maxDeliveryLatencyMicros, PendingIntent intent, long fastestIntervalMicros, int accuracyMode, List<LocationRequest> locationRequests, long registrationTimeOutMicros, IBinder callback, String packageName) {
        this.mVersionCode = versionCode;
        this.zzanm = dataSource;
        this.zzanl = dataType;
        this.zzaqi = listenerBinder == null ? null : zzj.zza.zzbl(listenerBinder);
        this.zzaoE = samplingIntervalMicros == 0L ? (long)samplingIntervalMicrosInt : samplingIntervalMicros;
        this.zzaqm = fastestIntervalMicros;
        this.zzaql = maxDeliveryLatencyMicros == 0L ? (long)maxDeliveryLatencyMicrosInt : maxDeliveryLatencyMicros;
        this.zzaqn = locationRequests;
        this.mPendingIntent = intent;
        this.zzaoF = accuracyMode;
        this.zzaqp = Collections.emptyList();
        this.zzaqo = registrationTimeOutMicros;
        this.zzapE = callback == null ? null : zznh.zza.zzbJ(callback);
        this.zzOZ = packageName;
    }

    public SensorRegistrationRequest(SensorRequest request, zzj listener, PendingIntent intent, zznh callback, String packageName) {
        this(request.getDataSource(), request.getDataType(), listener, intent, request.getSamplingRate(TimeUnit.MICROSECONDS), request.getFastestRate(TimeUnit.MICROSECONDS), request.getMaxDeliveryLatency(TimeUnit.MICROSECONDS), request.getAccuracyMode(), null, Collections.emptyList(), request.zzsu(), callback, packageName);
    }

    public SensorRegistrationRequest(DataSource dataSource, DataType dataType, zzj listener, PendingIntent pendingIntent, long samplingIntervalMicros, long fastestIntervalMicros, long maxDeliveryLatencyMicros, int accuracyMode, List<LocationRequest> locationRequests, List<Object> clientIdentities, long registrationTimeOutMicros, zznh callback, String packageName) {
        this.mVersionCode = 5;
        this.zzanm = dataSource;
        this.zzanl = dataType;
        this.zzaqi = listener;
        this.mPendingIntent = pendingIntent;
        this.zzaoE = samplingIntervalMicros;
        this.zzaqm = fastestIntervalMicros;
        this.zzaql = maxDeliveryLatencyMicros;
        this.zzaoF = accuracyMode;
        this.zzaqn = locationRequests;
        this.zzaqp = clientIdentities;
        this.zzaqo = registrationTimeOutMicros;
        this.zzapE = callback;
        this.zzOZ = packageName;
    }

    public DataSource getDataSource() {
        return this.zzanm;
    }

    public DataType getDataType() {
        return this.zzanl;
    }

    public PendingIntent zzso() {
        return this.mPendingIntent;
    }

    public long zzsp() {
        return this.zzaqm;
    }

    public long zzrP() {
        return this.zzaoE;
    }

    public long zzsq() {
        return this.zzaql;
    }

    public List<LocationRequest> zzsr() {
        return this.zzaqn;
    }

    public int getAccuracyMode() {
        return this.zzaoF;
    }

    public long zzss() {
        return this.zzaqo;
    }

    public IBinder zzsc() {
        return this.zzapE == null ? null : this.zzapE.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public String toString() {
        return String.format("SensorRegistrationRequest{type %s source %s interval %s fastest %s latency %s}", this.zzanl, this.zzanm, this.zzaoE, this.zzaqm, this.zzaql);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzst() {
        return this.zzaqi == null ? null : this.zzaqi.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzs.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRegistrationRequest && this.zzb((SensorRegistrationRequest)that);
    }

    private boolean zzb(SensorRegistrationRequest sensorRegistrationRequest) {
        return zzw.equal((Object)this.zzanm, (Object)sensorRegistrationRequest.zzanm) && zzw.equal((Object)this.zzanl, (Object)sensorRegistrationRequest.zzanl) && this.zzaoE == sensorRegistrationRequest.zzaoE && this.zzaqm == sensorRegistrationRequest.zzaqm && this.zzaql == sensorRegistrationRequest.zzaql && this.zzaoF == sensorRegistrationRequest.zzaoF && zzw.equal(this.zzaqn, sensorRegistrationRequest.zzaqn);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanm, this.zzanl, this.zzaqi, this.zzaoE, this.zzaqm, this.zzaql, this.zzaoF, this.zzaqn});
    }
}

