/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzp;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long zzMS;
    private final long zzann;
    private final String mName;
    private final String zzaoA;
    private final String zzaoB;
    private final int zzanx;
    private final Application zzanK;
    private final Long zzaoC;
    public static final Parcelable.Creator<Session> CREATOR = new zzp();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.mName = name;
        this.zzaoA = identifier;
        this.zzaoB = description;
        this.zzanx = activityType;
        this.zzanK = application;
        this.zzaoC = activeTimeMillis;
    }

    public Session(long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this(3, startTimeMillis, endTimeMillis, name, identifier, description, activityType, application, activeTimeMillis);
    }

    private Session(Builder builder) {
        this(builder.zzMS, builder.zzann, builder.mName, builder.zzaoA, builder.zzaoB, builder.zzanx, builder.zzanK, builder.zzaoC);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzMS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzann, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzx.zza((this.zzaoC != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaoC, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaoC != null;
    }

    public boolean isOngoing() {
        return this.zzann == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaoA;
    }

    public String getDescription() {
        return this.zzaoB;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzanx);
    }

    public int zzru() {
        return this.zzanx;
    }

    public Application zzrF() {
        return this.zzanK;
    }

    public String getAppPackageName() {
        return this.zzanK == null ? null : this.zzanK.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzMS == session.zzMS && this.zzann == session.zzann && zzw.equal((Object)this.mName, (Object)session.mName) && zzw.equal((Object)this.zzaoA, (Object)session.zzaoA) && zzw.equal((Object)this.zzaoB, (Object)session.zzaoB) && zzw.equal((Object)this.zzanK, (Object)session.zzanK) && this.zzanx == session.zzanx;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzMS, this.zzann, this.zzaoA});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("startTime", (Object)this.zzMS).zzg("endTime", (Object)this.zzann).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaoA).zzg("description", (Object)this.zzaoB).zzg("activity", (Object)this.zzanx).zzg("application", (Object)this.zzanK).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzkH() {
        return this.zzMS;
    }

    public long zzrw() {
        return this.zzann;
    }

    public Long zzrN() {
        return this.zzaoC;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzp.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzMS = 0L;
        private long zzann = 0L;
        private String mName = null;
        private String zzaoA;
        private String zzaoB;
        private int zzanx = 4;
        private Application zzanK;
        private Long zzaoC;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzx.zza((time > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzMS = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzx.zza((time >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzann = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzx.zzb((name.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzx.zzZ((identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0 ? 1 : 0) != 0);
            this.zzaoA = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzx.zzb((description.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzaoB = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzey(FitnessActivities.zzcP(activity));
        }

        public Builder zzey(int n) {
            this.zzanx = n;
            return this;
        }

        public Builder setActiveTime(long time, TimeUnit timeUnit) {
            this.zzaoC = timeUnit.toMillis(time);
            return this;
        }

        public Session build() {
            zzx.zza((this.zzMS > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzx.zza((this.zzann == 0L || this.zzann > this.zzMS ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaoA == null) {
                this.zzaoA = (this.mName == null ? "" : this.mName) + this.zzMS;
            }
            return new Session(this);
        }
    }
}

