/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF zzaVw;
    private float zzaHe;
    private float zzaHf;
    private float zzaVx;
    private float zzaVy;
    private List<Landmark> zzaVz;
    private float zzaVA;
    private float zzaVB;
    private float zzaVC;

    public PointF getPosition() {
        return new PointF(this.zzaVw.x - this.zzaHe / 2.0f, this.zzaVw.y - this.zzaHf / 2.0f);
    }

    public float getWidth() {
        return this.zzaHe;
    }

    public float getHeight() {
        return this.zzaHf;
    }

    public float getEulerY() {
        return this.zzaVx;
    }

    public float getEulerZ() {
        return this.zzaVy;
    }

    public List<Landmark> getLandmarks() {
        return this.zzaVz;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.zzaVA;
    }

    public float getIsRightEyeOpenProbability() {
        return this.zzaVB;
    }

    public float getIsSmilingProbability() {
        return this.zzaVC;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int id, PointF position, float width, float height, float yawDegrees, float rollDegrees, Landmark[] landmarks, float isLeftEyeOpenScore, float isRightEyeOpenScore, float isSmilingScore) {
        this.mId = id;
        this.zzaVw = position;
        this.zzaHe = width;
        this.zzaHf = height;
        this.zzaVx = yawDegrees;
        this.zzaVy = rollDegrees;
        this.zzaVz = Arrays.asList(landmarks);
        this.zzaVA = isLeftEyeOpenScore >= 0.0f && isLeftEyeOpenScore <= 1.0f ? isLeftEyeOpenScore : -1.0f;
        this.zzaVB = isRightEyeOpenScore >= 0.0f && isRightEyeOpenScore <= 1.0f ? isRightEyeOpenScore : -1.0f;
        this.zzaVC = this.zzaVC >= 0.0f && this.zzaVC <= 1.0f ? isSmilingScore : -1.0f;
    }
}

