/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zza;
import com.google.android.gms.internal.zzaa;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzf;
import com.google.android.gms.internal.zzh;
import com.google.android.gms.internal.zzi;
import com.google.android.gms.internal.zzj;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzp;
import com.google.android.gms.internal.zzq;
import com.google.android.gms.internal.zzr;
import com.google.android.gms.internal.zzs;
import com.google.android.gms.internal.zzu;
import com.google.android.gms.internal.zzy;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.cookie.DateUtils;

public class zzt
implements zzf {
    protected static final boolean DEBUG = zzs.DEBUG;
    private static int zzao = 3000;
    private static int zzap = 4096;
    protected final zzy zzaq;
    protected final zzu zzar;

    public zzt(zzy zzy2) {
        this(zzy2, new zzu(zzap));
    }

    public zzt(zzy zzy2, zzu zzu2) {
        this.zzaq = zzy2;
        this.zzar = zzu2;
    }

    @Override
    public zzi zza(zzk<?> zzk2) throws zzr {
        long l = SystemClock.elapsedRealtime();
        while (true) {
            HttpResponse httpResponse = null;
            byte[] byArray = null;
            Map<String, String> map = Collections.emptyMap();
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.zza(hashMap, zzk2.zzi());
                httpResponse = this.zzaq.zza(zzk2, hashMap);
                StatusLine statusLine = httpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                map = zzt.zza(httpResponse.getAllHeaders());
                if (n == 304) {
                    zzb.zza zza2 = zzk2.zzi();
                    if (zza2 == null) {
                        return new zzi(304, null, map, true, SystemClock.elapsedRealtime() - l);
                    }
                    zza2.zzg.putAll(map);
                    return new zzi(304, zza2.data, zza2.zzg, true, SystemClock.elapsedRealtime() - l);
                }
                byArray = httpResponse.getEntity() != null ? this.zza(httpResponse.getEntity()) : new byte[]{};
                long l2 = SystemClock.elapsedRealtime() - l;
                this.zza(l2, zzk2, byArray, statusLine);
                if (n < 200 || n > 299) {
                    throw new IOException();
                }
                return new zzi(n, byArray, map, false, SystemClock.elapsedRealtime() - l);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzt.zza("socket", zzk2, new zzq());
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                zzt.zza("connection", zzk2, new zzq());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Bad URL " + zzk2.getUrl(), malformedURLException);
            }
            catch (IOException iOException) {
                int n = 0;
                zzi zzi2 = null;
                if (httpResponse == null) {
                    throw new zzj(iOException);
                }
                n = httpResponse.getStatusLine().getStatusCode();
                zzs.zzc("Unexpected response code %d for %s", n, zzk2.getUrl());
                if (byArray != null) {
                    zzi2 = new zzi(n, byArray, map, false, SystemClock.elapsedRealtime() - l);
                    if (n == 401 || n == 403) {
                        zzt.zza("auth", zzk2, new zza(zzi2));
                        continue;
                    }
                    throw new zzp(zzi2);
                }
                throw new zzh(zzi2);
            }
            break;
        }
    }

    private void zza(long l, zzk<?> zzk2, byte[] byArray, StatusLine statusLine) {
        if (DEBUG || l > (long)zzao) {
            zzs.zzb("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", zzk2, l, byArray != null ? Integer.valueOf(byArray.length) : "null", statusLine.getStatusCode(), zzk2.zzu().zze());
        }
    }

    private static void zza(String string2, zzk<?> zzk2, zzr zzr2) throws zzr {
        zzo zzo2 = zzk2.zzu();
        int n = zzk2.zzt();
        try {
            zzo2.zza(zzr2);
        }
        catch (zzr zzr3) {
            zzk2.zzc(String.format("%s-timeout-giveup [timeout=%s]", string2, n));
            throw zzr3;
        }
        zzk2.zzc(String.format("%s-retry [timeout=%s]", string2, n));
    }

    private void zza(Map<String, String> map, zzb.zza zza2) {
        if (zza2 == null) {
            return;
        }
        if (zza2.zzb != null) {
            map.put("If-None-Match", zza2.zzb);
        }
        if (zza2.zzd > 0L) {
            Date date = new Date(zza2.zzd);
            map.put("If-Modified-Since", DateUtils.formatDate((Date)date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zza(HttpEntity httpEntity) throws IOException, zzp {
        zzaa zzaa2 = new zzaa(this.zzar, (int)httpEntity.getContentLength());
        byte[] byArray = null;
        try {
            int n;
            InputStream inputStream = httpEntity.getContent();
            if (inputStream == null) {
                throw new zzp();
            }
            byArray = this.zzar.zzb(1024);
            while ((n = inputStream.read(byArray)) != -1) {
                zzaa2.write(byArray, 0, n);
            }
            byte[] byArray2 = zzaa2.toByteArray();
            return byArray2;
        }
        finally {
            try {
                httpEntity.consumeContent();
            }
            catch (IOException iOException) {
                zzs.zza("Error occured when calling consumingContent", new Object[0]);
            }
            this.zzar.zza(byArray);
            zzaa2.close();
        }
    }

    protected static Map<String, String> zza(Header[] headerArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < headerArray.length; ++i) {
            treeMap.put(headerArray[i].getName(), headerArray[i].getValue());
        }
        return treeMap;
    }
}

