/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzh CREATOR = new zzh();
    private final int mVersionCode;
    private final List<LatLng> zzaHB;
    private final List<List<LatLng>> zzaHC;
    private float zzaGW = 10.0f;
    private int zzaGX = -16777216;
    private int zzaGY = 0;
    private float zzaGZ = 0.0f;
    private boolean zzaHa = true;
    private boolean zzaHD = false;

    public PolygonOptions() {
        this.mVersionCode = 1;
        this.zzaHB = new ArrayList<LatLng>();
        this.zzaHC = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.mVersionCode = versionCode;
        this.zzaHB = points;
        this.zzaHC = holes;
        this.zzaGW = strokeWidth;
        this.zzaGX = strokeColor;
        this.zzaGY = fillColor;
        this.zzaGZ = zIndex;
        this.zzaHa = visible;
        this.zzaHD = geodesic;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List zzxe() {
        return this.zzaHC;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzh.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzaHB.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzaHB.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzaHB.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzaHC.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzaGW = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zzaGX = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zzaGY = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzaGZ = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzaHa = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzaHD = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzaHB;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzaHC;
    }

    public float getStrokeWidth() {
        return this.zzaGW;
    }

    public int getStrokeColor() {
        return this.zzaGX;
    }

    public int getFillColor() {
        return this.zzaGY;
    }

    public float getZIndex() {
        return this.zzaGZ;
    }

    public boolean isVisible() {
        return this.zzaHa;
    }

    public boolean isGeodesic() {
        return this.zzaHD;
    }
}

