/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcn
implements zzp.zzf {
    private final Context mContext;
    private final String zzaOS;
    private final ExecutorService zzaRv;
    private zzbf<zzqh.zza> zzaRo;

    zzcn(Context context, String string) {
        this.mContext = context;
        this.zzaOS = string;
        this.zzaRv = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbf<zzqh.zza> zzbf2) {
        this.zzaRo = zzbf2;
    }

    @Override
    public void zzzM() {
        this.zzaRv.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzAD();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzAD() {
        if (this.zzaRo == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzaRo.zzzL();
        zzbg.v("Attempting to load resource from disk");
        if ((zzcb.zzAv().zzAw() == zzcb.zza.zzaRd || zzcb.zzAv().zzAw() == zzcb.zza.zzaRe) && this.zzaOS.equals(zzcb.zzAv().getContainerId())) {
            this.zzaRo.zza(zzbf.zza.zzaQC);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzAE());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaC("Failed to find the resource in the disk");
            this.zzaRo.zza(zzbf.zza.zzaQC);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzqp.zzc(fileInputStream, byteArrayOutputStream);
            zzqh.zza zza2 = zzqh.zza.zzs(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzaRo.zzB(zza2);
        }
        catch (IOException iOException) {
            this.zzaRo.zza(zzbf.zza.zzaQD);
            zzbg.zzaE("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzaRo.zza(zzbf.zza.zzaQD);
            zzbg.zzaE("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaE("Error closing stream for reading resource from disk");
            }
        }
        zzbg.v("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzqh.zza zza2) {
        this.zzaRv.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzqp.zzc zzjc(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzaE("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbg.v("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzqp.zzc(inputStream, byteArrayOutputStream);
            zzqp.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzr(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbg.zzaE("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzqp.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzaz.zzeN(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbg.zzaC("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbg.zzaE("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzqp.zzc zzr(byte[] byArray) {
        try {
            zzqp.zzc zzc2 = zzqp.zzb(zzaf.zzf.zzc(byArray));
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzrw zzrw2) {
            zzbg.e("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzqp.zzg zzg2) {
            zzbg.zzaE("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzaRv.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzqh.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzAE();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.e("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzrx.zzf((zzrx)zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbg.zzaE("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaE("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzAE() {
        String string = "resource_" + this.zzaOS;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void zzd(zzqh.zza zza2) throws IllegalArgumentException {
        if (zza2.zziR == null && zza2.zzaTu == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

