/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.internal.zzoq;
import java.util.HashMap;
import java.util.Map;

public final class zzot
implements Application.ActivityLifecycleCallbacks {
    private final zzoj zzaIR;
    private final Map<Activity, zzoq> zzaIS;

    public zzot(zzoj zzoj2) {
        zzx.zzv((Object)zzoj2);
        this.zzaIR = zzoj2;
        this.zzaIS = new HashMap<Activity, zzoq>();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        Bundle bundle = savedInstanceState.getBundle("com.google.android.gms.measurement.screen_view");
        if (bundle == null) {
            return;
        }
        int n = bundle.getInt("id");
        if (n <= 0) {
            Log.w((String)"com.google.android.gms.measurement.internal.ActivityLifecycleTracker", (String)"Invalid screenId in saved activity state");
            return;
        }
        zzoq zzoq2 = this.zza(activity, n);
        zzoq2.setScreenName(bundle.getString("name"));
        zzoq2.zzhT(bundle.getInt("referrer_id"));
        zzoq2.zzdU(bundle.getString("referrer_name"));
        zzoq2.zzam(bundle.getBoolean("interstitial"));
        zzoq2.zzxX();
    }

    public void onActivityStarted(Activity activity) {
        zzoq zzoq2 = this.zza(activity, 0);
        this.zzaIR.zzb(zzoq2, activity);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (outState == null) {
            return;
        }
        zzoq zzoq2 = this.zzaIS.get(activity);
        if (zzoq2 == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("id", zzoq2.zzbp());
        bundle.putString("name", zzoq2.zzxT());
        bundle.putInt("referrer_id", zzoq2.zzxU());
        bundle.putString("referrer_name", zzoq2.zzxV());
        bundle.putBoolean("interstitial", zzoq2.zzxY());
        outState.putBundle("com.google.android.gms.measurement.screen_view", bundle);
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzaIS.remove(activity);
    }

    zzoq zza(Activity activity, int n) {
        zzx.zzv((Object)activity);
        zzoq zzoq2 = this.zzaIS.get(activity);
        if (zzoq2 == null) {
            zzoq2 = n == 0 ? new zzoq(true) : new zzoq(true, n);
            zzoq2.setScreenName(activity.getClass().getCanonicalName());
            this.zzaIS.put(activity, zzoq2);
        }
        return zzoq2;
    }
}

