/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzor;
import com.google.android.gms.internal.zzos;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zzoh {
    private static DecimalFormat zzKk;
    private final zzf zzKa;
    private final String zztw;
    private final Uri zzKl;
    private final boolean zzKm;
    private final boolean zzKn;

    public zzb(zzf zzf2, String string) {
        this(zzf2, string, true, false);
    }

    public zzb(zzf zzf2, String string, boolean bl, boolean bl2) {
        super(zzf2);
        zzx.zzcs((String)string);
        this.zzKa = zzf2;
        this.zztw = string;
        this.zzKm = bl;
        this.zzKn = bl2;
        this.zzKl = zzb.zzaP(this.zztw);
    }

    static Uri zzaP(String string) {
        zzx.zzcs((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zzhs() {
        return this.zzKl;
    }

    @Override
    public void zzb(zzob zzob2) {
        zzx.zzv((Object)zzob2);
        zzx.zzb((boolean)zzob2.zzxm(), (Object)"Can't deliver not submitted measurement");
        zzx.zzci((String)"deliver should be called on worker thread");
        zzob zzob3 = zzob2.zzxh();
        zzjb zzjb2 = zzob3.zze(zzjb.class);
        if (TextUtils.isEmpty((CharSequence)zzjb2.zzhK())) {
            this.zzie().zzh(zzb.zzc(zzob3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzjb2.getClientId())) {
            this.zzie().zzh(zzb.zzc(zzob3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzKa.zzis().getAppOptOut()) {
            return;
        }
        double d = zzjb2.zzhP();
        if (zzam.zza(d, zzjb2.getClientId())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzob3);
        map.put("v", "1");
        map.put("_v", zze.zzLB);
        map.put("tid", this.zztw);
        if (this.zzKa.zzis().isDryRunEnabled()) {
            String string = zzb.zzy(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzam.zzb(hashMap, "uid", zzjb2.getUserId());
        zzok zzok2 = zzob2.zzd(zzok.class);
        if (zzok2 != null) {
            zzam.zzb(hashMap, "an", zzok2.zzjZ());
            zzam.zzb(hashMap, "aid", zzok2.zztW());
            zzam.zzb(hashMap, "av", zzok2.zzkb());
            zzam.zzb(hashMap, "aiid", zzok2.zzxA());
        }
        zzh zzh2 = new zzh(0L, zzjb2.getClientId(), this.zztw, !TextUtils.isEmpty((CharSequence)zzjb2.zzhL()), 0L, hashMap);
        long l = this.zzhz().zza(zzh2);
        map.put("_s", String.valueOf(l));
        zzab zzab2 = new zzab(this.zzie(), map, zzob2.zzxk(), true);
        this.zzhz().zza(zzab2);
    }

    public static Map<String, String> zzc(zzob zzob2) {
        zzok zzok2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zziy zziy2;
        zzos zzos2;
        zzor zzor2;
        zzop zzop2;
        zzol zzol2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzja zzja2 = zzob2.zzd(zzja.class);
        if (zzja2 != null) {
            object7 = zzja2.zzhJ().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zzh(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zzob2.zzd(zzjb.class)) != null) {
            zzb.zza(hashMap, "t", ((zzjb)object7).zzhK());
            zzb.zza(hashMap, "cid", ((zzjb)object7).getClientId());
            zzb.zza(hashMap, "uid", ((zzjb)object7).getUserId());
            zzb.zza(hashMap, "sc", ((zzjb)object7).zzhN());
            zzb.zza(hashMap, "sf", ((zzjb)object7).zzhP());
            zzb.zza(hashMap, "ni", ((zzjb)object7).zzhO());
            zzb.zza(hashMap, "adid", ((zzjb)object7).zzhL());
            zzb.zza(hashMap, "ate", ((zzjb)object7).zzhM());
        }
        if ((object6 = zzob2.zzd(zzoq.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzoq)object6).zzxT());
            zzb.zza(hashMap, "a", ((zzoq)object6).zzbp());
            zzb.zza(hashMap, "dr", ((zzoq)object6).zzxW());
        }
        if ((object5 = zzob2.zzd(zzoo.class)) != null) {
            zzb.zza(hashMap, "ec", ((zzoo)object5).zzxQ());
            zzb.zza(hashMap, "ea", ((zzoo)object5).getAction());
            zzb.zza(hashMap, "el", ((zzoo)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzoo)object5).getValue());
        }
        if ((zzol2 = zzob2.zzd(zzol.class)) != null) {
            zzb.zza(hashMap, "cn", zzol2.getName());
            zzb.zza(hashMap, "cs", zzol2.getSource());
            zzb.zza(hashMap, "cm", zzol2.zzxB());
            zzb.zza(hashMap, "ck", zzol2.zzxC());
            zzb.zza(hashMap, "cc", zzol2.getContent());
            zzb.zza(hashMap, "ci", zzol2.getId());
            zzb.zza(hashMap, "anid", zzol2.zzxD());
            zzb.zza(hashMap, "gclid", zzol2.zzxE());
            zzb.zza(hashMap, "dclid", zzol2.zzxF());
            zzb.zza(hashMap, "aclid", zzol2.zzxG());
        }
        if ((zzop2 = zzob2.zzd(zzop.class)) != null) {
            zzb.zza(hashMap, "exd", zzop2.getDescription());
            zzb.zza(hashMap, "exf", zzop2.zzxR());
        }
        if ((zzor2 = zzob2.zzd(zzor.class)) != null) {
            zzb.zza(hashMap, "sn", zzor2.zzya());
            zzb.zza(hashMap, "sa", zzor2.getAction());
            zzb.zza(hashMap, "st", zzor2.getTarget());
        }
        if ((zzos2 = zzob2.zzd(zzos.class)) != null) {
            zzb.zza(hashMap, "utv", zzos2.zzyb());
            zzb.zza(hashMap, "utt", zzos2.getTimeInMillis());
            zzb.zza(hashMap, "utc", zzos2.zzxQ());
            zzb.zza(hashMap, "utl", zzos2.getLabel());
        }
        if ((zziy2 = zzob2.zzd(zziy.class)) != null) {
            object4 = zziy2.zzhH();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzP((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zzob2.zzd(zziz.class)) != null) {
            object3 = ((zziz)object4).zzhI();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzR((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzob2.zzd(zzon.class)) != null) {
            object2 = ((zzon)object3).zzxM();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzon)object3).zzxP()) {
                hashMap.putAll(promotion.zzaV(com.google.android.gms.analytics.zzc.zzV(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzon)object3).zzxN()) {
                hashMap.putAll(product.zzaV(com.google.android.gms.analytics.zzc.zzT(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzon)object3).zzxO().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzY(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzaV(string + com.google.android.gms.analytics.zzc.zzW(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(string + "nm", entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzob2.zzd(zzom.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzom)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzom)object2).zzxH());
            zzb.zza(hashMap, "sr", ((zzom)object2).zzxI(), ((zzom)object2).zzxJ());
            zzb.zza(hashMap, "vp", ((zzom)object2).zzxK(), ((zzom)object2).zzxL());
        }
        if ((zzok2 = zzob2.zzd(zzok.class)) != null) {
            zzb.zza(hashMap, "an", zzok2.zzjZ());
            zzb.zza(hashMap, "aid", zzok2.zztW());
            zzb.zza(hashMap, "aiid", zzok2.zzxA());
            zzb.zza(hashMap, "av", zzok2.zzkb());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zzb(double d) {
        if (zzKk == null) {
            zzKk = new DecimalFormat("0.######");
        }
        return zzKk.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, n + "x" + n2);
        }
    }

    private static String zzy(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zzh(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zzb(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

