/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzn
extends zzd {
    private volatile String zzLd;
    private Future<String> zzMG;

    protected zzn(zzf zzf2) {
        super(zzf2);
    }

    @Override
    protected void zzhB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzjd() {
        this.zzio();
        zzn zzn2 = this;
        synchronized (zzn2) {
            if (this.zzLd == null) {
                this.zzMG = this.zzig().zzb(new Callable<String>(){

                    public String zzji() throws Exception {
                        return zzn.this.zzjf();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzji();
                    }
                });
            }
            if (this.zzMG != null) {
                try {
                    this.zzLd = this.zzMG.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzLd = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzLd = "0";
                }
                if (this.zzLd == null) {
                    this.zzLd = "0";
                }
                this.zza("Loaded clientId", this.zzLd);
                this.zzMG = null;
            }
            return this.zzLd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzje() {
        zzn zzn2 = this;
        synchronized (zzn2) {
            this.zzLd = null;
            this.zzMG = this.zzig().zzb(new Callable<String>(){

                public String zzji() throws Exception {
                    return zzn.this.zzjg();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzji();
                }
            });
        }
        return this.zzjd();
    }

    String zzjf() {
        String string = this.zzZ(this.zzig().getContext());
        if (string == null) {
            string = this.zzjg();
        }
        return string;
    }

    private String zzjg() {
        String string = this.zzjh();
        try {
            if (!this.zzg(this.zzig().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    protected String zzjh() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzZ(Context context) {
        zzx.zzci((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (fileInputStream.available() > 0) {
                this.zzbb("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            if (n < 14) {
                this.zzbb("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            String string = null;
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzg(Context context, String string) {
        zzx.zzcs((String)string);
        zzx.zzci((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

