/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;

class zzag
extends BroadcastReceiver {
    static final String zzOo = zzag.class.getName();
    private final zzf zzLy;
    private boolean zzOp;
    private boolean zzOq;

    zzag(zzf zzf2) {
        zzx.zzv((Object)zzf2);
        this.zzLy = zzf2;
    }

    public void onReceive(Context ctx, Intent intent) {
        this.zzks();
        String string = intent.getAction();
        this.zzLy.zzie().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzku();
            if (this.zzOq != bl) {
                this.zzOq = bl;
                this.zzhz().zzI(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzOo)) {
                this.zzhz().zzhY();
            }
            return;
        }
        this.zzLy.zzie().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzkr() {
        this.zzks();
        if (this.zzOp) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzOq = this.zzku();
        this.zzLy.zzie().zza("Registering connectivity change receiver. Network connected", this.zzOq);
        this.zzOp = true;
    }

    private void zzks() {
        this.zzie();
        this.zzhz();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzLy.zzie().zzaY("Unregistering connectivity change receiver");
        this.zzOp = false;
        this.zzOq = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzie().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzkt() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzOo, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzOp;
    }

    public boolean isConnected() {
        if (!this.zzOp) {
            this.zzLy.zzie().zzbb("Connectivity unknown. Receiver not registered");
        }
        return this.zzOq;
    }

    protected boolean zzku() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzLy.getContext();
    }

    private zzaf zzie() {
        return this.zzLy.zzie();
    }

    private zzb zzhz() {
        return this.zzLy.zzhz();
    }
}

