/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzok;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzKH;
    private final Map<String, String> zzvs = new HashMap<String, String>();
    private final Map<String, String> zzKI = new HashMap<String, String>();
    private final zzad zzKJ;
    private final zza zzKK;
    private ExceptionReporter zzKL;
    private zzal zzKM;

    Tracker(zzf analytics, String trackingId, zzad rateLimiter) {
        super(analytics);
        if (trackingId != null) {
            this.zzvs.put("&tid", trackingId);
        }
        this.zzvs.put("useSecure", "1");
        this.zzvs.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzKJ = rateLimiter == null ? new zzad("tracking") : rateLimiter;
        this.zzKK = new zza(analytics);
    }

    @Override
    protected void zzhB() {
        String string;
        this.zzKK.zza();
        String string2 = this.zzhA().zzjZ();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzhA().zzkb()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzal zzal2) {
        String string;
        this.zzaY("Loading Tracker config values");
        this.zzKM = zzal2;
        if (this.zzKM.zzkM()) {
            string = this.zzKM.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzKM.zzkN()) {
            string = Double.toString(this.zzKM.zzkO());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzKM.zzkP()) {
            int n = this.zzKM.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzKM.zzkQ()) {
            boolean bl = this.zzKM.zzkR();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzKM.zzkS()) {
            boolean bl = this.zzKM.zzkT();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzKM.zzkU());
    }

    private boolean zzhC() {
        return this.zzKL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzhC() == enable) {
                return;
            }
            if (enable) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzKL = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzKL);
                this.zzaY("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzKL.zzhv();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzaY("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzKK.setSessionTimeout(sessionTimeout * 1000L);
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzKK.enableAutoActivityTracking(enabled);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        zzx.zzv(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzx.zzv(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> params) {
        final long l = this.zzid().currentTimeMillis();
        if (this.zzhu().getAppOptOut()) {
            this.zzaZ("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzhu().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zzvs, hashMap);
        Tracker.zza(params, hashMap);
        final boolean bl2 = zzam.zze(this.zzvs.get("useSecure"), true);
        Tracker.zzb(this.zzKI, hashMap);
        this.zzKI.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzie().zzh(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzie().zzh(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzhD();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzvs.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzvs.put("&a", Integer.toString(n));
            }
        }
        this.zzig().zzf(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzKK.zzhE()) {
                    hashMap.put("sc", "start");
                }
                zzam.zzc(hashMap, "cid", Tracker.this.zzhu().getClientId());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zzam.zza(d = zzam.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzik();
                if (bl3) {
                    zzam.zzb((Map<String, String>)hashMap, "ate", zza2.zzhM());
                    zzam.zzb((Map<String, String>)hashMap, "adid", zza2.zzhQ());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzok zzok2 = Tracker.this.zzil().zziL();
                zzam.zzb((Map<String, String>)hashMap, "an", zzok2.zzjZ());
                zzam.zzb((Map<String, String>)hashMap, "av", zzok2.zzkb());
                zzam.zzb((Map<String, String>)hashMap, "aid", zzok2.zztW());
                zzam.zzb((Map<String, String>)hashMap, "aiid", zzok2.zzxA());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.zzLB);
                zzam.zzb((Map<String, String>)hashMap, "ul", Tracker.this.zzim().zzjS().getLanguage());
                zzam.zzb((Map<String, String>)hashMap, "sr", Tracker.this.zzim().zzjT());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzKJ.zzkp()) {
                    Tracker.this.zzie().zzh(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzam.zzbo((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zzie().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzam.zza(hashMap2, "uid", hashMap);
                zzam.zza(hashMap2, "an", hashMap);
                zzam.zza(hashMap2, "aid", hashMap);
                zzam.zza(hashMap2, "av", hashMap);
                zzam.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzhz().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzhz().zza(zzab3);
            }
        });
    }

    public String get(String key) {
        this.zzio();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzvs.containsKey(key)) {
            return this.zzvs.get(key);
        }
        if (key.equals("&ul")) {
            return zzam.zza(Locale.getDefault());
        }
        if (key.equals("&cid")) {
            return this.zzij().zzjd();
        }
        if (key.equals("&sr")) {
            return this.zzim().zzjT();
        }
        if (key.equals("&aid")) {
            return this.zzil().zziL().zztW();
        }
        if (key.equals("&an")) {
            return this.zzil().zziL().zzjZ();
        }
        if (key.equals("&av")) {
            return this.zzil().zziL().zzkb();
        }
        if (key.equals("&aiid")) {
            return this.zzil().zziL().zzxA();
        }
        return null;
    }

    public void set(String key, String value) {
        zzx.zzb((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.zzvs.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzam.zzJ(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            this.zzbb("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzam.zzJ(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string));
        String string2 = uri2.getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzKI.put("&ci", string2);
        }
        if ((string2 = uri2.getQueryParameter("anid")) != null) {
            this.zzKI.put("&anid", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzKI.put("&cn", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzKI.put("&cc", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzKI.put("&cm", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzKI.put("&cs", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzKI.put("&ck", string2);
        }
        if ((string2 = uri2.getQueryParameter("dclid")) != null) {
            this.zzKI.put("&dclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("gclid")) != null) {
            this.zzKI.put("&gclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("aclid")) != null) {
            this.zzKI.put("&aclid", string2);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        this.zzKH = enabled;
    }

    boolean zzhD() {
        return this.zzKH;
    }

    static String zzq(Activity activity) {
        zzx.zzv((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzKV;
        private int zzKW;
        private long zzKX;
        private boolean zzKY;
        private long zzKZ;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.zzKX = -1L;
        }

        @Override
        protected void zzhB() {
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.zzKX = sessionTimeout;
            this.zzhF();
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzKV = enabled;
            this.zzhF();
        }

        public synchronized boolean zzhE() {
            boolean bl = this.zzKY;
            this.zzKY = false;
            return bl;
        }

        private void zzhF() {
            if (this.zzKX >= 0L || this.zzKV) {
                this.zzhu().zza(Tracker.this.zzKK);
            } else {
                this.zzhu().zzb(Tracker.this.zzKK);
            }
        }

        @Override
        public void zzo(Activity activity) {
            if (this.zzKW == 0 && this.zzhG()) {
                this.zzKY = true;
            }
            ++this.zzKW;
            if (this.zzKV) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzKM != null ? Tracker.this.zzKM.zzr(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzq(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzp(Activity activity) {
            --this.zzKW;
            this.zzKW = Math.max(0, this.zzKW);
            if (this.zzKW == 0) {
                this.zzKZ = this.zzid().elapsedRealtime();
            }
        }

        boolean zzhG() {
            return this.zzid().elapsedRealtime() >= this.zzKZ + Math.max(1000L, this.zzKX);
        }
    }
}

