/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzKt = new ArrayList<Runnable>();
    private boolean zzpr;
    private boolean zzKu;
    private Set<zza> zzKv = new HashSet<zza>();
    private boolean zzKw;
    private boolean zzKx;
    private volatile boolean zzKy;
    private boolean zzKz;

    public void zza() {
        this.zzhw();
        this.zzpr = true;
    }

    void zzhw() {
        Logger logger;
        zzan zzan2 = this.zzhA();
        if (zzan2.zzkc()) {
            this.getLogger().setLogLevel(zzan2.getLogLevel());
        }
        if (zzan2.zzkg()) {
            this.setDryRun(zzan2.zzkh());
        }
        if (zzan2.zzkc() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzan2.getLogLevel());
        }
    }

    public boolean isInitialized() {
        return this.zzpr && !this.zzKu;
    }

    public GoogleAnalytics(zzf context) {
        super(context);
    }

    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzX(context).zzis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzhx() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzKt != null) {
                for (Runnable runnable : zzKt) {
                    runnable.run();
                }
                zzKt = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean dryRun) {
        this.zzKx = dryRun;
    }

    public boolean isDryRunEnabled() {
        return this.zzKx;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzKw) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzKw = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzKw) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzKv) {
            zza2.zzo(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzKw) {
            this.zzn(activity);
        }
    }

    void zzn(Activity activity) {
        for (zza zza2 : this.zzKv) {
            zza2.zzp(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzhp(), trackingId, null);
            tracker.zza();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzak zzak2;
            zzal zzal2;
            Tracker tracker = new Tracker(this.zzhp(), null, null);
            if (configResId > 0 && (zzal2 = (zzal)(zzak2 = new zzak(this.zzhp())).zzac(configResId)) != null) {
                tracker.zza(zzal2);
            }
            tracker.zza();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzKv.add(zza2);
        Context context = this.zzhp().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzKv.remove(zza2);
    }

    public void setAppOptOut(boolean optOut) {
        this.zzKy = optOut;
        if (this.zzKy) {
            this.zzhz().zzhU();
        }
    }

    public boolean getAppOptOut() {
        return this.zzKy;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzKz) {
            Log.i((String)zzy.zzNa.get(), (String)("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag." + zzy.zzNa.get() + " DEBUG"));
            this.zzKz = true;
        }
    }

    public String getClientId() {
        zzx.zzci((String)"getClientId can not be called from the main thread");
        return this.zzhp().zziv().zzjd();
    }

    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zzhz().setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    public void dispatchLocalHits() {
        this.zzhz().zzhV();
    }

    void zzhy() {
        this.zzhz().zzhW();
    }

    private com.google.android.gms.analytics.internal.zzb zzhz() {
        return this.zzhp().zzhz();
    }

    private zzan zzhA() {
        return this.zzhp().zzhA();
    }

    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzn(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzo(Activity var1);

        public void zzp(Activity var1);
    }
}

