/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzd;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzd zzaVr;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzd nativeDetector) {
        this.zzaVr = nativeDetector;
    }

    @Override
    public SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        Frame.Metadata metadata = frame.getMetadata();
        FrameMetadataParcel frameMetadataParcel = FrameMetadataParcel.zzc(frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzaVr.zza(frame.getBitmap(), frameMetadataParcel);
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzaVr.zza(byteBuffer, frameMetadataParcel);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        for (Barcode barcode : barcodeArray) {
            byteBuffer.append(barcode.rawValue.hashCode(), barcode);
        }
        return byteBuffer;
    }

    @Override
    public boolean isOperational() {
        return this.zzaVr.isOperational();
    }

    public static class Builder {
        private Context mContext;
        private BarcodeDetectorOptions zzaVs;

        public Builder(Context context) {
            this.mContext = context;
            this.zzaVs = new BarcodeDetectorOptions();
        }

        public Builder setBarcodeFormats(int format) {
            this.zzaVs.zzaVt = format;
            return this;
        }

        public BarcodeDetector build() {
            zzd zzd2 = new zzd(this.mContext, this.zzaVs);
            return new BarcodeDetector(zzd2);
        }
    }
}

