/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.ViewOffsetBehavior;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;

abstract class HeaderScrollingViewBehavior
extends ViewOffsetBehavior<View> {
    public HeaderScrollingViewBehavior() {
    }

    public HeaderScrollingViewBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onMeasureChild(CoordinatorLayout parent, View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int childLpHeight = child.getLayoutParams().height;
        if (childLpHeight == -1 || childLpHeight == -2) {
            List<View> dependencies = parent.getDependencies(child);
            if (dependencies.isEmpty()) {
                return false;
            }
            View header = this.findFirstDependency(dependencies);
            if (header != null && ViewCompat.isLaidOut((View)header)) {
                int availableHeight;
                if (ViewCompat.getFitsSystemWindows((View)header)) {
                    ViewCompat.setFitsSystemWindows((View)child, (boolean)true);
                }
                if ((availableHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec)) == 0) {
                    availableHeight = parent.getHeight();
                }
                int height = availableHeight - header.getMeasuredHeight() + this.getScrollRange(header);
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)(childLpHeight == -1 ? 0x40000000 : Integer.MIN_VALUE));
                parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightMeasureSpec, heightUsed);
                return true;
            }
        }
        return false;
    }

    abstract View findFirstDependency(List<View> var1);

    int getScrollRange(View v) {
        return v.getMeasuredHeight();
    }
}

