/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzb;
import java.util.HashSet;
import java.util.Set;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Set<String> zzazN = new HashSet<String>();
    private int zzazO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
        if (SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            String string = intent.getStringExtra("tag");
            Parcelable parcelable = intent.getParcelableExtra("callback");
            Bundle bundle = (Bundle)intent.getParcelableExtra("extras");
            if (parcelable == null || !(parcelable instanceof PendingCallback)) {
                Log.e((String)"GcmTaskService", (String)(this.getPackageName() + " " + string + ": Could not process request, invalid callback."));
                return 2;
            }
            Set<String> set = this.zzazN;
            synchronized (set) {
                this.zzazN.add(string);
                this.stopSelf(this.zzazO);
                this.zzazO = startId;
            }
            new zza(string, ((PendingCallback)parcelable).getIBinder(), bundle).start();
        } else if (SERVICE_ACTION_INITIALIZE.equals(intent.getAction())) {
            this.onInitializeTasks();
            Set<String> set = this.zzazN;
            synchronized (set) {
                this.zzazO = startId;
                if (this.zzazN.size() == 0) {
                    this.stopSelf(this.zzazO);
                }
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzdn(String string) {
        Set<String> set = this.zzazN;
        synchronized (set) {
            this.zzazN.remove(string);
            if (this.zzazN.size() == 0) {
                this.stopSelf(this.zzazO);
            }
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    private class zza
    extends Thread {
        private final String mTag;
        private final zzb zzazP;
        private final Bundle mExtras;

        zza(String string, IBinder iBinder, Bundle bundle) {
            this.mTag = string;
            this.zzazP = zzb.zza.zzbR(iBinder);
            this.mExtras = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = GcmTaskService.this.onRunTask(new TaskParams(this.mTag, this.mExtras));
            try {
                this.zzazP.zzgs(n);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"GcmTaskService", (String)("Error reporting result of operation to scheduler for " + this.mTag));
            }
            finally {
                GcmTaskService.this.zzdn(this.mTag);
            }
        }
    }
}

