/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzo;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.query.Query;
import java.util.List;

public class zzr
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.zza((zzc.zza)new zzg(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new QueryRequest(query), (zzam)new zzi((zzc.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.zza(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zzc.zza)new zzb(googleApiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new CreateContentsRequest(n), (zzam)new zzh((zzc.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.zza((zzc.zza)new zze(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new GetMetadataRequest(DriveId.zzcC(resourceId), false), (zzam)new zzc((zzc.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzv(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzx(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        return new zzx(zzt2.zzqG());
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        DriveId driveId = zzt2.zzqH();
        return driveId != null ? new zzx(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient apiClient) {
        return apiClient.zza((zzc.zza)new zzs<BooleanResult>(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                final 5 var2_2 = this;
                zzt2.zzqF().zze(new com.google.android.gms.drive.internal.zzd(){

                    @Override
                    public void zzaa(boolean bl) {
                        var2_2.zza((Result)new BooleanResult(Status.zzaaD, bl));
                    }
                });
            }

            protected BooleanResult zzz(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzz(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        return zzt2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zzc.zzb<DriveApi.MetadataBufferResult> zzQz;

        public zzi(zzc.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzqT());
            this.zzQz.zzn((Object)new zzf(Status.zzaaD, metadataBuffer, onListEntriesResponse.zzqU()));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzQz.zzn((Object)new zzf(status, null, false));
        }
    }

    static class zzf
    implements DriveApi.MetadataBufferResult {
        private final Status zzQA;
        private final MetadataBuffer zzain;
        private final boolean zzaio;

        public zzf(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzQA = status;
            this.zzain = metadataBuffer;
            this.zzaio = bl;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzain;
        }

        public void release() {
            if (this.zzain != null) {
                this.zzain.release();
            }
        }
    }

    static abstract class zzg
    extends zzs<DriveApi.MetadataBufferResult> {
        zzg(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzC(Status status) {
            return new zzf(status, null, false);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzC(status);
        }
    }

    static class zzc
    extends com.google.android.gms.drive.internal.zzd {
        private final zzc.zzb<DriveApi.DriveIdResult> zzQz;

        public zzc(zzc.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzQz.zzn((Object)new zzd(Status.zzaaD, new zzo(onMetadataResponse.zzqW()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzQz.zzn((Object)new zzd(Status.zzaaD, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzQz.zzn((Object)new zzd(status, null));
        }
    }

    private static class zzd
    implements DriveApi.DriveIdResult {
        private final Status zzQA;
        private final DriveId zzags;

        public zzd(Status status, DriveId driveId) {
            this.zzQA = status;
            this.zzags = driveId;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzags;
        }
    }

    static abstract class zze
    extends zzs<DriveApi.DriveIdResult> {
        zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzB(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzB(status);
        }
    }

    private static class zzh
    extends com.google.android.gms.drive.internal.zzd {
        private final zzc.zzb<DriveApi.DriveContentsResult> zzQz;

        public zzh(zzc.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzQz.zzn((Object)new zza(Status.zzaaD, new zzu(onContentsResponse.zzqN())));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzQz.zzn((Object)new zza(status, null));
        }
    }

    static class zza
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzQA;
        private final DriveContents zzagv;

        public zza(Status status, DriveContents driveContents) {
            this.zzQA = status;
            this.zzagv = driveContents;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzagv;
        }

        public void release() {
            if (this.zzagv != null) {
                this.zzagv.zzqi();
            }
        }
    }

    static abstract class zzb
    extends zzs<DriveApi.DriveContentsResult> {
        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzA(Status status) {
            return new zza(status, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzA(status);
        }
    }

    static class zzj
    extends zzs.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zza((Result)status);
        }

        protected void zza(zzt zzt2) {
        }
    }
}

