/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zzln;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzatI;
    private final String zzahh;
    private final Uri zzaqW;
    private final Uri zzaqX;
    private final int zzxJ;
    private final String zzasH;
    private final boolean zzayg;
    private final PlayerEntity zzarZ;
    private final int zzTv;
    private final ParticipantResult zzayh;
    private final String zzarh;
    private final String zzari;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.zzatI = participant.getParticipantId();
        this.zzahh = participant.getDisplayName();
        this.zzaqW = participant.getIconImageUri();
        this.zzaqX = participant.getHiResImageUri();
        this.zzxJ = participant.getStatus();
        this.zzasH = participant.zztD();
        this.zzayg = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzarZ = player == null ? null : new PlayerEntity(player);
        this.zzTv = participant.getCapabilities();
        this.zzayh = participant.getResult();
        this.zzarh = participant.getIconImageUrl();
        this.zzari = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.mVersionCode = versionCode;
        this.zzatI = participantId;
        this.zzahh = displayName;
        this.zzaqW = iconImageUri;
        this.zzaqX = hiResImageUri;
        this.zzxJ = status;
        this.zzasH = clientAddress;
        this.zzayg = connectedToRoom;
        this.zzarZ = player;
        this.zzTv = capabilities;
        this.zzayh = result;
        this.zzarh = iconImageUrl;
        this.zzari = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzxJ;
    }

    @Override
    public String zztD() {
        return this.zzasH;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzayg;
    }

    @Override
    public String getDisplayName() {
        if (this.zzarZ == null) {
            return this.zzahh;
        }
        return this.zzarZ.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzarZ == null) {
            zzln.zzb((String)this.zzahh, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzarZ.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzarZ == null) {
            return this.zzaqW;
        }
        return this.zzarZ.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzarZ == null) {
            return this.zzarh;
        }
        return this.zzarZ.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzarZ == null) {
            return this.zzaqX;
        }
        return this.zzarZ.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzarZ == null) {
            return this.zzari;
        }
        return this.zzarZ.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzatI;
    }

    @Override
    public Player getPlayer() {
        return this.zzarZ;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzayh;
    }

    @Override
    public int getCapabilities() {
        return this.zzTv;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzw.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zztD(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzw.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzw.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzw.equal((Object)participant2.zztD(), (Object)participant.zztD()) && zzw.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzw.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzw.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzw.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzw.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzw.equal((Object)participant2.getResult(), (Object)participant.getResult()) && zzw.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzw.zzu((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zztD()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzos()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzatI);
            dest.writeString(this.zzahh);
            dest.writeString(this.zzaqW == null ? null : this.zzaqW.toString());
            dest.writeString(this.zzaqX == null ? null : this.zzaqX.toString());
            dest.writeInt(this.zzxJ);
            dest.writeString(this.zzasH);
            dest.writeInt(this.zzayg ? 1 : 0);
            dest.writeInt(this.zzarZ == null ? 0 : 1);
            if (this.zzarZ != null) {
                this.zzarZ.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzdU(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zzor());
            if (bl || ParticipantEntity.zzcj((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzdU(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, n2, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdU(x0);
        }
    }
}

