/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.signin.internal.zzi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class GamesClientImpl
extends zzj<IGamesService> {
    EventIncrementManager zzasJ = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzue() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzasK;
    private PlayerEntity zzasL;
    private GameEntity zzasM;
    private final PopupManager zzasN;
    private boolean zzasO = false;
    private final Binder zzasP;
    private final long zzasQ;
    private final Games.GamesOptions zzasR;

    public GamesClientImpl(Context context, Looper looper, zzf clientSettings, Games.GamesOptions options, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        super(context, looper, 1, clientSettings, connectedListener, connectionFailedListener);
        this.zzasK = clientSettings.zzol();
        this.zzasP = new Binder();
        this.zzasN = PopupManager.zza(this, clientSettings.zzoh());
        this.zzm(clientSettings.zzon());
        this.zzasQ = ((Object)((Object)this)).hashCode();
        this.zzasR = options;
    }

    public boolean zzlm() {
        return true;
    }

    public void zzou() {
        super.zzou();
        if (this.zzasO) {
            this.zzasN.zzup();
            this.zzasO = false;
        }
        if (!this.zzasR.zzarv) {
            this.zztG();
        }
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzasO = false;
    }

    public void zzfM(int n) {
        this.zzasN.setGravity(n);
    }

    public void zzm(View view) {
        this.zzasN.zzn(view);
    }

    protected Set<Scope> zza(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzx.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzx.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(GoogleApiClient.zza zza2) {
        this.zztF();
        super.zza(zza2);
    }

    public void disconnect() {
        this.zzasO = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzoA();
                iGamesService.zzud();
                this.zzasJ.flush();
                iGamesService.zzE(this.zzasQ);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzw("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzfA() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzfB() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzbN(IBinder iBinder) {
        return IGamesService.Stub.zzbQ(iBinder);
    }

    public Bundle zzmw() {
        try {
            Bundle bundle = ((IGamesService)this.zzoA()).zzmw();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zztF() {
        this.zzasL = null;
        this.zzasM = null;
    }

    protected Bundle zzli() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzasR.zzsQ();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzasK);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzasN.zzur()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 0);
        zzf zzf2 = this.zzoy();
        if (zzf2.zzoo() != null) {
            bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzi.zza((com.google.android.gms.signin.zze)zzf2.zzoo(), (Integer)zzf2.zzop(), (ExecutorService)Executors.newSingleThreadExecutor()));
        }
        return bundle;
    }

    public void zztG() {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzasN);
            ((IGamesService)this.zzoA()).zza(popupLocationInfoBinderCallbacks, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zztH() {
        try {
            return ((IGamesService)this.zzoA()).zztH();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public String zztI() {
        if (this.zzasL != null) {
            return this.zzasL.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzoA()).zztI();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zztJ() {
        this.zzoz();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzasL == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzoA()).zzuf());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzasL = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzasL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zztK() {
        this.zzoz();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzasM == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzoA()).zzuh());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzasM = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzasM;
    }

    public void zza(zzc.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzc.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzc.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzoA()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzc.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzc.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zztL() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztL();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzp(String string, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zzw(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzc.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzc.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzuR().asBundle(), n, n2);
    }

    public void zza(zzc.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zztM() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztM();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzc.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzc.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzasN.zzur(), this.zzasN.zzuq());
    }

    public void zzb(zzc.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzasN.zzur(), this.zzasN.zzuq());
    }

    public void zza(zzc.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzasN.zzur(), this.zzasN.zzuq());
    }

    public void zzb(zzc.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzasN.zzur(), this.zzasN.zzuq());
    }

    public void zzd(zzc.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzc.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzq(String string, int n) {
        this.zzasJ.zzq(string, n);
    }

    public Intent zztN() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztN();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zztO() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztO();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzl<OnInvitationReceivedListener> zzl2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzl2);
            ((IGamesService)this.zzoA()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zztP() {
        try {
            ((IGamesService)this.zzoA()).zzF(this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzl<OnTurnBasedMatchUpdateReceivedListener> zzl2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzl2);
            ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zztQ() {
        try {
            ((IGamesService)this.zzoA()).zzG(this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzl<QuestUpdateListener> zzl2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzl2);
            ((IGamesService)this.zzoA()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zztR() {
        try {
            ((IGamesService)this.zzoA()).zzI(this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzl<OnRequestReceivedListener> zzl2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzl2);
            ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zztS() {
        try {
            ((IGamesService)this.zzoA()).zzH(this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zztT() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztT();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zztU() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztU();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzc.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzb(zzc.zzb<Status> zzb2) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zztV() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzoA()).zztV();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zztW() {
        try {
            return ((IGamesService)this.zzoA()).zztW();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzc(zzc.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzr(String string, int n) {
        try {
            ((IGamesService)this.zzoA()).zzr(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzs(String string, int n) {
        try {
            ((IGamesService)this.zzoA()).zzs(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzuX(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzl(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzm(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zztX() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzoA()).zztX();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zzc.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzc.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzc.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzo(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzc.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzc.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzn(new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzcX(String string) {
        try {
            ((IGamesService)this.zzoA()).zzdf(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzc.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzc.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzp(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzl<RoomUpdateListener> zzl2, zzl<RoomStatusUpdateListener> zzl3, zzl<RealTimeMessageReceivedListener> zzl4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzl2, zzl3, zzl4);
            ((IGamesService)this.zzoA()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzasP, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzl<RoomUpdateListener> zzl2, zzl<RoomStatusUpdateListener> zzl3, zzl<RealTimeMessageReceivedListener> zzl4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzl2, zzl3, zzl4);
            ((IGamesService)this.zzoA()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzasP, roomConfig.getInvitationId(), false, this.zzasQ);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzl<RoomUpdateListener> zzl2, String string) {
        try {
            ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzl2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzl<RealTimeMultiplayer.ReliableMessageSentCallback> zzl2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzl2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzx.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzoA()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zzd(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzoA()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzfN(int n) {
        try {
            ((IGamesService)this.zzoA()).zzfN(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zztY() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zztY();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zza(n, byArray, n2, string);
            zzx.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zztZ() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzoA()).zztZ();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzua() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzoA()).zzua();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zzc.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzc.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzc.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzc.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzc.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzcY(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zzcY(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzc.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zzu(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzc.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzc.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzc.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzcZ(String string) {
        try {
            ((IGamesService)this.zzoA()).zza(string, this.zzasN.zzur(), this.zzasN.zzuq());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzc.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzc.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzasJ.flush();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzub() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzoA()).zzub();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzuc() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzoA()).zzuc();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzoA()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzc.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzc.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzc.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzvc();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzqh();
        snapshotContents.close();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzqh();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzoA()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zzc.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzr(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzc.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzvc();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzqh();
        snapshotContents.close();
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzj(zzc.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzc.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzq(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zzc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzoA()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzc.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzc.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzc.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzs(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zzc.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzd(zzc.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzg(zzc.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzg((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zzh(zzc.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zzb(zzc.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzoA()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zze(zzc.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzoA()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzc.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzk(new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzc.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zzg(zzc.zzb<Acls.LoadAclResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzh(new NotifyAclLoadedBinderCallback(zzb2));
    }

    public void zzn(zzc.zzb<Status> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzj(new NotifyAclUpdatedBinderCallback(zzb2), string);
    }

    public void zzd(zzc.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzo(zzc.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzoA()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzi(zzc.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzc.zzb<Status> zzb2, boolean bl, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bundle);
    }

    public void zzh(zzc.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzoA()).zzt(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzc.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzc.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzc.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzf(zzc.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzoA()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzc.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzoA()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzoA()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzud() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzoA()).zzud();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzb("GamesClientImpl", "service died", remoteException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Room zzV(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzasO = bundle.getBoolean("show_welcome_popup");
            this.zzasL = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzasM = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzbN(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzQA;
        private final String zzasZ;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.zzQA = GamesStatusCodes.zzfx(statusCode);
            this.zzasZ = snapshotId;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public String getSnapshotId() {
            return this.zzasZ;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzasY;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzasY = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzasY;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzatD;
        private final String zzatE;
        private final Snapshot zzatF;
        private final Contents zzatG;
        private final SnapshotContents zzatH;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzatD = null;
                    this.zzatF = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzb.zzY((metadataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzatD = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    this.zzatF = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzatD = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.zzatF = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzatE = conflictId;
            this.zzatG = resolutionContents;
            this.zzatH = new SnapshotContentsEntity(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzatD;
        }

        @Override
        public String getConflictId() {
            return this.zzatE;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzatF;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzatH;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzYX);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzatq;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzatq = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity(playerStatsBuffer.zzgp(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzati;

        LoadAppContentsResultImpl(DataHolder[] appContentData) {
            super(appContentData[0]);
            this.zzati = new ArrayList<DataHolder>(Arrays.asList(appContentData));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzasX;
        private final Quest zzasU;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzasU = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzasU.zzuZ();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(milestoneId)) continue;
                        this.zzasX = list.get(i);
                        return;
                    }
                    this.zzasX = null;
                } else {
                    this.zzasX = null;
                    this.zzasU = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzasX;
        }

        @Override
        public Quest getQuest() {
            return this.zzasU;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzasU;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzasU = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzasU;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzYX;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzYX = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzYX);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzQA;
        private final Bundle zzatt;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.zzQA = status;
            this.zzatt = requestData;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = RequestType.zzfQ(requestType);
            if (!this.zzatt.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzatt.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzatt.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzatt.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzaui;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaui = RequestUpdateOutcomes.zzY(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.zzaui.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzaui.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzatQ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzatQ = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzQA;
        private final Bundle zzatc;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.zzQA = status;
            this.zzatc = inboxCounts;
        }

        public Status getStatus() {
            return this.zzQA;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzQA;
        private final String zzata;
        private final boolean zzatb;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzQA = GamesStatusCodes.zzfx(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzata = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzatb = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzata = null;
                    this.zzatb = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzQA;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzQA;
        private final String zzata;
        private final boolean zzatb;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.zzQA = GamesStatusCodes.zzfx(statusCode);
            this.zzata = externalGameId;
            this.zzatb = isMuted;
        }

        public Status getStatus() {
            return this.zzQA;
        }
    }

    private static final class LoadAclResultImpl
    extends GamesDataHolderResult
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzQA;
        private final String zzasW;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.zzQA = status;
            this.zzasW = externalMatchId;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public String getMatchId() {
            return this.zzasW;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzatA;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzatA = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzatA;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzaub;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzaub = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzaub;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends GamesDataHolderResult
    implements Players.LoadProfileSettingsResult {
        private final boolean zzasG;
        private final boolean zzats;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n = dataHolder.zzbo(0);
                    this.zzasG = dataHolder.zze("profile_visible", 0, n);
                    this.zzats = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
                } else {
                    this.zzasG = true;
                    this.zzats = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public boolean isProfileVisible() {
            return this.zzasG;
        }

        @Override
        public boolean isVisibilityExplicitlySet() {
            return this.zzats;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzaty;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaty = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzQA;
        private final List<String> zzatw;
        private final Bundle zzatx;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.zzQA = status;
            this.zzatw = xpData.getStringArrayList("game_category_list");
            this.zzatx = xpData;
        }

        public Status getStatus() {
            return this.zzQA;
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzatr;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzatr = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzatr;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzQA;
        private final LoadMatchesResponse zzato;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.zzQA = status;
            this.zzato = new LoadMatchesResponse(matchData);
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzato;
        }

        public void release() {
            this.zzato.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzatn;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzatn = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzatn;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzatp;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.zzatp = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzatp;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzatu;
        private final LeaderboardScoreBuffer zzatv;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.zzatu = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzatv = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzatu;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzatv;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzatf;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzatf = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzatf;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzatl;

        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
            this.zzatl = new GameSearchSuggestionBuffer(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzatk;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzatk = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzatm;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzatm = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzatm;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzatj;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzatj = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzatj;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzQA;
        private final String zzarS;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.zzQA = GamesStatusCodes.zzfx(statusCode);
            this.zzarS = achievementId;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public String getAchievementId() {
            return this.zzarS;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzath;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzath = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzath;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zze {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzfx(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzl.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzWu;
        private final String zzatN;
        private final int zzatO;

        RealTimeMessageSentNotifier(int statusCode, int token, String recipientParticipantId) {
            this.zzWu = statusCode;
            this.zzatO = token;
            this.zzatN = recipientParticipantId;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzWu, this.zzatO, this.zzatN);
            }
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzl.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzatB;

        MessageReceivedNotifier(RealTimeMessage message) {
            this.zzatB = message;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzatB);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzl.zzb<RoomStatusUpdateListener> {
        private final String zzatI;

        P2PDisconnectedNotifier(String participantId) {
            this.zzatI = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzatI);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzl.zzb<RoomStatusUpdateListener> {
        private final String zzatI;

        P2PConnectedNotifier(String participantId) {
            this.zzatI = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzatI);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzl.zzb<RoomUpdateListener> {
        private final int zzWu;
        private final String zzatg;

        LeftRoomNotifier(int statusCode, String roomId) {
            this.zzWu = statusCode;
            this.zzatg = roomId;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzWu, this.zzatg);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzasT = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder);
            int n = participantIds.length;
            for (int i = 0; i < n; ++i) {
                this.zzasT.add(participantIds[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzasT);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzd<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzV(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzd<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzV(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzl.zzb<OnNearbyPlayerDetectedListener> {
        private final Player zzatC;

        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(this.zzatC);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzl.zzb<OnRequestReceivedListener> {
        private final String zzBm;

        RequestRemovedNotifier(String requestId) {
            this.zzBm = requestId;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzBm);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzl.zzb<OnRequestReceivedListener> {
        private final GameRequest zzatQ;

        RequestReceivedNotifier(GameRequest request) {
            this.zzatQ = request;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzatQ);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzl.zzb<QuestUpdateListener> {
        private final Quest zzasU;

        QuestCompletedNotifier(Quest quest) {
            this.zzasU = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzasU);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzl.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzatz;

        MatchRemovedNotifier(String matchId) {
            this.zzatz = matchId;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzatz);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzl.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzatA;

        MatchUpdateReceivedNotifier(TurnBasedMatch match) {
            this.zzatA = match;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzatA);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzl.zzb<OnInvitationReceivedListener> {
        private final String zzate;

        InvitationRemovedNotifier(String invitationId) {
            this.zzate = invitationId;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzate);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzl.zzb<OnInvitationReceivedListener> {
        private final Invitation zzatd;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzatd = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzatd);
        }

        public void zznh() {
        }

        public /* synthetic */ void zzo(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Snapshots.DeleteSnapshotResult> zzQz;

        public SnapshotDeletedBinderCallbacks(zzc.zzb<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            this.zzQz.zzn((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Snapshots.CommitSnapshotResult> zzatY;

        public SnapshotCommittedBinderCallbacks(zzc.zzb<Snapshots.CommitSnapshotResult> resultHolder) {
            this.zzatY = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzatY.zzn((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Snapshots.OpenSnapshotResult> zzatZ;

        public SnapshotOpenedBinderCallbacks(zzc.zzb<Snapshots.OpenSnapshotResult> resultHolder) {
            this.zzatZ = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.zzatZ.zzn((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.zzatZ.zzn((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Snapshots.LoadSnapshotsResult> zzaua;

        public SnapshotsLoadedBinderCallbacks(zzc.zzb<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.zzaua = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzaua.zzn((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Stats.LoadPlayerStatsResult> zzQz;

        public PlayerStatsLoadedBinderCallbacks(zzc.zzb<Stats.LoadPlayerStatsResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzU(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<AppContents.LoadAppContentResult> zzasV;

        public AppContentLoadedBinderCallbacks(zzc.zzb<AppContents.LoadAppContentResult> resultHolder) {
            this.zzasV = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzasV.zzn((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Quests.LoadQuestsResult> zzatM;

        public QuestsLoadedBinderCallbacks(zzc.zzb<Quests.LoadQuestsResult> resultHolder) {
            this.zzatM = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            this.zzatM.zzn((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Quests.ClaimMilestoneResult> zzatK;
        private final String zzatL;

        public QuestMilestoneClaimBinderCallbacks(zzc.zzb<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.zzatK = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
            this.zzatL = (String)zzx.zzb((Object)milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzatK.zzn((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzatL));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Quests.AcceptQuestResult> zzatJ;

        public QuestAcceptedBinderCallbacks(zzc.zzb<Quests.AcceptQuestResult> resultHolder) {
            this.zzatJ = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzatJ.zzn((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Requests.LoadRequestSummariesResult> zzatS;

        public RequestSummariesLoadedBinderCallbacks(zzc.zzb<Requests.LoadRequestSummariesResult> resultHolder) {
            this.zzatS = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzatS.zzn((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Requests.LoadRequestsResult> zzatT;

        public RequestsLoadedBinderCallbacks(zzc.zzb<Requests.LoadRequestsResult> resultHolder) {
            this.zzatT = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfx(n);
            this.zzatT.zzn((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Requests.SendRequestResult> zzatR;

        public RequestSentBinderCallbacks(zzc.zzb<Requests.SendRequestResult> resultHolder) {
            this.zzatR = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzatR.zzn((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Requests.UpdateRequestsResult> zzatU;

        public RequestsUpdatedBinderCallbacks(zzc.zzb<Requests.UpdateRequestsResult> resultHolder) {
            this.zzatU = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzatU.zzn((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzasN;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzasN = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zztC() {
            return new PopupLocationInfoParcelable(this.zzasN.zzus());
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Status> zzQz;

        public SignOutCompleteBinderCallbacks(zzc.zzb<Status> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzll() {
            Status status = GamesStatusCodes.zzfx(0);
            this.zzQz.zzn((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Notifications.InboxCountResult> zzQz;

        InboxCountsLoadedBinderCallback(zzc.zzb<Notifications.InboxCountResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfx(n);
            this.zzQz.zzn((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Status> zzQz;

        ContactSettingsUpdatedBinderCallback(zzc.zzb<Status> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzfJ(int n) {
            this.zzQz.zzn((Object)GamesStatusCodes.zzfx(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Notifications.ContactSettingLoadResult> zzQz;

        ContactSettingsLoadedBinderCallback(zzc.zzb<Notifications.ContactSettingLoadResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Notifications.GameMuteStatusLoadResult> zzQz;

        GameMuteStatusLoadedBinderCallback(zzc.zzb<Notifications.GameMuteStatusLoadResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Notifications.GameMuteStatusChangeResult> zzQz;

        GameMuteStatusChangedBinderCallback(zzc.zzb<Notifications.GameMuteStatusChangeResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzQz.zzn((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Status> zzQz;

        NotifyAclUpdatedBinderCallback(zzc.zzb<Status> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzfI(int n) {
            this.zzQz.zzn((Object)GamesStatusCodes.zzfx(n));
        }
    }

    private static final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Acls.LoadAclResult> zzQz;

        NotifyAclLoadedBinderCallback(zzc.zzb<Acls.LoadAclResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadAclResultImpl(dataHolder));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzl<RealTimeMultiplayer.ReliableMessageSentCallback> zzatP;

        public RealTimeReliableMessageBinderCallbacks(zzl<RealTimeMultiplayer.ReliableMessageSentCallback> messageSentCallbacks) {
            this.zzatP = messageSentCallbacks;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzatP != null) {
                this.zzatP.zza((zzl.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzl<? extends RoomUpdateListener> zzatV;
        private final zzl<? extends RoomStatusUpdateListener> zzatW;
        private final zzl<RealTimeMessageReceivedListener> zzatX;

        public RoomBinderCallbacks(zzl<RoomUpdateListener> roomCallbacks) {
            this.zzatV = (zzl)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzatW = null;
            this.zzatX = null;
        }

        public RoomBinderCallbacks(zzl<? extends RoomUpdateListener> roomCallbacks, zzl<? extends RoomStatusUpdateListener> roomStatusCallbacks, zzl<RealTimeMessageReceivedListener> realTimeMessageReceivedCallbacks) {
            this.zzatV = (zzl)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzatW = roomStatusCallbacks;
            this.zzatX = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzatV.zza((zzl.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzy(DataHolder dataHolder) {
            this.zzatV.zza((zzl.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            this.zzatV.zza((zzl.zzb)new LeftRoomNotifier(statusCode, externalRoomId));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            this.zzatV.zza((zzl.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String participantId) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new P2PConnectedNotifier(participantId));
            }
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            if (this.zzatW != null) {
                this.zzatW.zza((zzl.zzb)new P2PDisconnectedNotifier(participantId));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            if (this.zzatX != null) {
                this.zzatX.zza((zzl.zzb)new MessageReceivedNotifier(message));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<TurnBasedMultiplayer.CancelMatchResult> zzauc;

        public TurnBasedMatchCanceledBinderCallbacks(zzc.zzb<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.zzauc = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzfx(n);
            this.zzauc.zzn((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzaue;

        public TurnBasedMatchLeftBinderCallbacks(zzc.zzb<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.zzaue = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzaue.zzn((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzaug;

        public TurnBasedMatchUpdatedBinderCallbacks(zzc.zzb<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.zzaug = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzaug.zzn((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzaud;

        public TurnBasedMatchInitiatedBinderCallbacks(zzc.zzb<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.zzaud = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzt(DataHolder dataHolder) {
            this.zzaud.zzn((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<TurnBasedMultiplayer.LoadMatchResult> zzauf;

        public TurnBasedMatchLoadedBinderCallbacks(zzc.zzb<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.zzauf = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzs(DataHolder dataHolder) {
            this.zzauf.zzn((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzauh;

        public TurnBasedMatchesLoadedBinderCallbacks(zzc.zzb<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.zzauh = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfx(n);
            this.zzauh.zzn((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Leaderboards.SubmitScoreResult> zzQz;

        public SubmitScoreBinderCallbacks(zzc.zzb<Leaderboards.SubmitScoreResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Status> zzQz;

        ProfileSettingsUpdatedBinderCallback(zzc.zzb<Status> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzfK(int n) {
            this.zzQz.zzn((Object)GamesStatusCodes.zzfx(n));
        }
    }

    static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Players.LoadProfileSettingsResult> zzQz;

        ProfileSettingsLoadedBinderCallback(zzc.zzb<Players.LoadProfileSettingsResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Players.LoadXpStreamResult> zzQz;

        PlayerXpStreamLoadedBinderCallback(zzc.zzb<Players.LoadXpStreamResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzS(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Players.LoadXpForGameCategoriesResult> zzQz;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzc.zzb<Players.LoadXpForGameCategoriesResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfx(n);
            this.zzQz.zzn((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Players.LoadPlayersResult> zzQz;

        PlayersLoadedBinderCallback(zzc.zzb<Players.LoadPlayersResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzl<OnRequestReceivedListener> zzaiL;

        RequestReceivedBinderCallback(zzl<OnRequestReceivedListener> listener) {
            this.zzaiL = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzr(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzaiL.zza((zzl.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            this.zzaiL.zza((zzl.zzb)new RequestRemovedNotifier(requestId));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzl<QuestUpdateListener> zzaiL;

        QuestUpdateBinderCallback(zzl<QuestUpdateListener> listener) {
            this.zzaiL = listener;
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            Quest quest = this.zzX(dataHolder);
            if (quest != null) {
                this.zzaiL.zza((zzl.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzX(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzl<OnTurnBasedMatchUpdateReceivedListener> zzaiL;

        MatchUpdateReceivedBinderCallback(zzl<OnTurnBasedMatchUpdateReceivedListener> listener) {
            this.zzaiL = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzw(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzaiL.zza((zzl.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            this.zzaiL.zza((zzl.zzb)new MatchRemovedNotifier(matchId));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzl<OnInvitationReceivedListener> zzaiL;

        InvitationReceivedBinderCallback(zzl<OnInvitationReceivedListener> listener) {
            this.zzaiL = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzq(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzaiL.zza((zzl.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            this.zzaiL.zza((zzl.zzb)new InvitationRemovedNotifier(invitationId));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Invitations.LoadInvitationsResult> zzQz;

        InvitationsLoadedBinderCallback(zzc.zzb<Invitations.LoadInvitationsResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Leaderboards.LoadPlayerScoreResult> zzQz;

        PlayerLeaderboardScoreLoadedBinderCallback(zzc.zzb<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzH(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Leaderboards.LoadScoresResult> zzQz;

        LeaderboardScoresLoadedBinderCallback(zzc.zzb<Leaderboards.LoadScoresResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzQz.zzn((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Leaderboards.LeaderboardMetadataResult> zzQz;

        LeaderboardsLoadedBinderCallback(zzc.zzb<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzQz;

        GameSearchSuggestionsLoadedBinderCallback(zzc.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzo(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<GamesMetadata.LoadGameInstancesResult> zzQz;

        GameInstancesLoadedBinderCallback(zzc.zzb<GamesMetadata.LoadGameInstancesResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Events.LoadEventsResult> zzQz;

        EventsLoadedBinderCallback(zzc.zzb<Events.LoadEventsResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<GamesMetadata.LoadGamesResult> zzQz;

        GamesLoadedBinderCallback(zzc.zzb<GamesMetadata.LoadGamesResult> holder) {
            this.zzQz = (zzc.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Achievements.UpdateAchievementResult> zzQz;

        AchievementUpdatedBinderCallback(zzc.zzb<Achievements.UpdateAchievementResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, String string) {
            this.zzQz.zzn((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzc.zzb<Achievements.LoadAchievementsResult> zzQz;

        AchievementsLoadedBinderCallback(zzc.zzb<Achievements.LoadAchievementsResult> resultHolder) {
            this.zzQz = (zzc.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzt(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzoA()).zzq(string, n);
                } else {
                    GamesLog.zzx("GamesClientImpl", "Unable to increment event " + string + " by " + n + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

