/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzls;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzQD;
    private int zzUS;
    private String zzUe;
    private String zzUg;
    private String mName;
    private String zzUc;
    private int zzUT;
    private JSONObject zzUl;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzf(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.zzQD = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzUS = type;
    }

    public long getId() {
        return this.zzQD;
    }

    public int getType() {
        return this.zzUS;
    }

    public String getContentId() {
        return this.zzUe;
    }

    public void setContentId(String contentId) {
        this.zzUe = contentId;
    }

    public String getContentType() {
        return this.zzUg;
    }

    public void setContentType(String contentType) {
        this.zzUg = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzUc;
    }

    void setLanguage(String language) {
        this.zzUc = language;
    }

    public int getSubtype() {
        return this.zzUT;
    }

    void zzaO(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzUS != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzUT = n;
    }

    public JSONObject getCustomData() {
        return this.zzUl;
    }

    void setCustomData(JSONObject customData) {
        this.zzUl = customData;
    }

    private void clear() {
        this.zzQD = 0L;
        this.zzUS = 0;
        this.zzUe = null;
        this.mName = null;
        this.zzUc = null;
        this.zzUT = -1;
        this.zzUl = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzf(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzQD = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.zzUS = 1;
        } else if ("AUDIO".equals(string)) {
            this.zzUS = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.zzUS = 3;
        }
        this.zzUe = jSONObject.optString("trackContentId", null);
        this.zzUg = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzUc = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.zzUT = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.zzUT = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.zzUT = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.zzUT = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.zzUT = 5;
            }
        } else {
            this.zzUT = 0;
        }
        this.zzUl = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzQD);
            switch (this.zzUS) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzUe != null) {
                jSONObject.put("trackContentId", (Object)this.zzUe);
            }
            if (this.zzUg != null) {
                jSONObject.put("trackContentType", (Object)this.zzUg);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzUc)) {
                jSONObject.put("language", (Object)this.zzUc);
            }
            switch (this.zzUT) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzUl != null) {
                jSONObject.put("customData", (Object)this.zzUl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzUl == null != (mediaTrack.zzUl == null)) {
            return false;
        }
        if (this.zzUl != null && mediaTrack.zzUl != null && !zzls.zzd((Object)this.zzUl, (Object)mediaTrack.zzUl)) {
            return false;
        }
        return this.zzQD == mediaTrack.zzQD && this.zzUS == mediaTrack.zzUS && zzf.zza(this.zzUe, mediaTrack.zzUe) && zzf.zza(this.zzUg, mediaTrack.zzUg) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzUc, mediaTrack.zzUc) && this.zzUT == mediaTrack.zzUT;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQD, this.zzUS, this.zzUe, this.zzUg, this.mName, this.zzUc, this.zzUT, this.zzUl});
    }

    public static class Builder {
        private final MediaTrack zzUU;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzUU = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzUU.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzUU.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzUU.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzUU.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzUU.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzUU.zzaO(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzUU.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzUU;
        }
    }
}

