/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzlm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzgk
public class zzdu
extends zzdr {
    private static final Set<String> zzxB = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzxC = new DecimalFormat("#,###");
    private File zzxD;
    private boolean zzxE;

    public zzdu(zzip zzip2) {
        super(zzip2);
        Context context = zzip2.getContext();
        File file = context.getCacheDir();
        if (file == null) {
            zzb.zzaE("Context.getCacheDir() returned null");
            return;
        }
        this.zzxD = new File(file, "admobVideoStreams");
        if (!this.zzxD.isDirectory() && !this.zzxD.mkdirs()) {
            zzb.zzaE("Could not create preload cache directory at " + this.zzxD.getAbsolutePath());
            this.zzxD = null;
            return;
        }
        if (!this.zzxD.setReadable(true, false) || !this.zzxD.setExecutable(true, false)) {
            zzb.zzaE("Could not set cache file permissions at " + this.zzxD.getAbsolutePath());
            this.zzxD = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzZ(String string2) {
        if (this.zzxD == null) {
            this.zzf(string2, null);
            return false;
        }
        while (this.zzdH() > zzby.zzuj.get()) {
            if (this.zzdI()) continue;
            zzb.zzaE("Unable to expire stream cache");
            this.zzf(string2, null);
            return false;
        }
        String string3 = this.zzaa(string2);
        File file = new File(this.zzxD, string3);
        File file2 = this.zza(file);
        if (file.isFile() && file2.isFile()) {
            int n = (int)file.length();
            zzb.zzaC("Stream cache hit at " + string2);
            this.zza(string2, file.getAbsolutePath(), n);
            return true;
        }
        String string4 = this.zzxD.getAbsolutePath() + string2;
        Object object = zzxB;
        synchronized (object) {
            if (zzxB.contains(string4)) {
                zzb.zzaE("Stream cache already in progress at " + string2);
                this.zzf(string2, file.getAbsolutePath());
                return false;
            }
            zzxB.add(string4);
        }
        object = null;
        try {
            int n;
            int n2;
            URLConnection uRLConnection = new URL(string2).openConnection();
            int n3 = zzby.zzuo.get();
            uRLConnection.setConnectTimeout(n3);
            uRLConnection.setReadTimeout(n3);
            if (uRLConnection instanceof HttpURLConnection && (n2 = ((HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                throw new IOException("HTTP status code " + n2 + " at " + string2);
            }
            n2 = uRLConnection.getContentLength();
            if (n2 < 0) {
                zzb.zzaE("Stream cache aborted, missing content-length header at " + string2);
                this.zzf(string2, file.getAbsolutePath());
                zzxB.remove(string4);
                return false;
            }
            String string5 = zzxC.format(n2);
            int n4 = zzby.zzuk.get();
            if (n2 > n4) {
                zzb.zzaE("Content length " + string5 + " exceeds limit at " + string2);
                this.zzf(string2, file.getAbsolutePath());
                zzxB.remove(string4);
                return false;
            }
            zzb.zzaC("Caching " + string5 + " bytes from " + string2);
            InputStream inputStream = uRLConnection.getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            object = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzlm zzlm2 = zzp.zzbB();
            int n5 = 0;
            long l = zzlm2.currentTimeMillis();
            long l2 = zzby.zzun.get();
            zzib zzib2 = new zzib(l2);
            long l3 = zzby.zzum.get();
            while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n5 += n) > n4) {
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l4 = zzlm2.currentTimeMillis();
                if (l4 - l > l3 * 1000L) {
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzxE) {
                    throw new IOException("abort requested");
                }
                if (!zzib2.tryAcquire()) continue;
                this.zza(string2, file.getAbsolutePath(), n5, n2, false);
            }
            ((FileOutputStream)object).close();
            if (zzb.zzM(3)) {
                String string6 = zzxC.format(n5);
                zzb.zzaC("Preloaded " + string6 + " bytes from " + string2);
            }
            file.setReadable(true, false);
            zzdu.zzb(file2);
            this.zza(string2, file.getAbsolutePath(), n5);
            zzxB.remove(string4);
            return true;
        }
        catch (IOException iOException) {
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            if (this.zzxE) {
                zzb.zzaD("Preload aborted for URL \"" + string2 + "\"");
            } else {
                zzb.zzd("Preload failed for URL \"" + string2 + "\"", iOException);
            }
            if (file.exists() && !file.delete()) {
                zzb.zzaE("Could not delete partial cache file at " + file.getAbsolutePath());
            }
            this.zzf(string2, file.getAbsolutePath());
            zzxB.remove(string4);
            return false;
        }
    }

    @Override
    public void abort() {
        this.zzxE = true;
    }

    public int zzdH() {
        if (this.zzxD == null) {
            return 0;
        }
        int n = 0;
        for (File file : this.zzxD.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n;
        }
        return n;
    }

    public boolean zzdI() {
        if (this.zzxD == null) {
            return false;
        }
        File file = null;
        long l = Long.MAX_VALUE;
        for (File file2 : this.zzxD.listFiles()) {
            long l2;
            if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
            file = file2;
            l = l2;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zza(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private File zza(File file) {
        return new File(this.zzxD, file.getName() + ".done");
    }

    private static void zzb(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

