/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhu;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzgk
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzAb = new HashMap<Integer, String>();
    private final zzp zzAc;
    private int zzAd = 0;
    private int zzAe = 0;
    private MediaPlayer zzAf;
    private Uri zzAg;
    private int zzAh;
    private int zzAi;
    private int zzAj;
    private int zzAk;
    private int zzAl;
    private float zzAm = 1.0f;
    private boolean zzAn;
    private boolean zzAo;
    private int zzAp;
    private zzh zzAq;

    public zzc(Context context, zzp zzp2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzAc = zzp2;
        this.zzAc.zza(this);
    }

    @Override
    public String zzek() {
        return "MediaPlayer";
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzAq = zzh2;
    }

    @Override
    public void setMimeType(String mimeType) {
    }

    @Override
    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.zzAg = uri;
        this.zzAp = 0;
        this.zzel();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzb.v("AdVideoView stop");
        if (this.zzAf != null) {
            this.zzAf.stop();
            this.zzAf.release();
            this.zzAf = null;
            this.zzt(0);
            this.zzu(0);
            this.zzeo();
        }
        this.zzAc.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        zzb.v("AdVideoView size changed: " + width + " x " + height);
        this.zzAh = mp.getVideoWidth();
        this.zzAi = mp.getVideoHeight();
        if (this.zzAh != 0 && this.zzAi != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzb.v("AdVideoView prepared");
        this.zzt(2);
        this.zzAc.zzeL();
        zzhu.zzHK.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzAq != null) {
                    zzc.this.zzAq.zzeL();
                }
            }
        });
        this.zzAh = mediaPlayer.getVideoWidth();
        this.zzAi = mediaPlayer.getVideoHeight();
        if (this.zzAp != 0) {
            this.seekTo(this.zzAp);
        }
        this.zzem();
        zzb.zzaD("AdVideoView stream dimensions: " + this.zzAh + " x " + this.zzAi);
        if (this.zzAe == 3) {
            this.play();
        }
        this.zzen();
        this.zzeu();
    }

    public void onCompletion(MediaPlayer mp) {
        zzb.v("AdVideoView completion");
        this.zzt(5);
        this.zzu(5);
        zzhu.zzHK.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzAq != null) {
                    zzc.this.zzAq.zzeN();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        String string = zzAb.get(what);
        String string2 = zzAb.get(extra);
        zzb.v("AdVideoView MediaPlayer info: " + string + ":" + string2);
        return true;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        final String string = zzAb.get(what);
        final String string2 = zzAb.get(extra);
        zzb.zzaE("AdVideoView MediaPlayer error: " + string + ":" + string2);
        this.zzt(-1);
        this.zzu(-1);
        zzhu.zzHK.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzAq != null) {
                    zzc.this.zzAq.zzh(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.zzAj = percent;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        zzb.v("AdVideoView surface created");
        this.zzel();
        zzhu.zzHK.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzAq != null) {
                    zzc.this.zzAq.zzeK();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int w, int h) {
        boolean bl;
        zzb.v("AdVideoView surface changed");
        boolean bl2 = this.zzAe == 3;
        boolean bl3 = bl = this.zzAh == w && this.zzAi == h;
        if (this.zzAf != null && bl2 && bl) {
            if (this.zzAp != 0) {
                this.seekTo(this.zzAp);
            }
            this.play();
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        zzb.v("AdVideoView surface destroyed");
        if (this.zzAf != null && this.zzAp == 0) {
            this.zzAp = this.zzAf.getCurrentPosition();
        }
        zzhu.zzHK.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzAq != null) {
                    zzc.this.zzAq.onPaused();
                    zzc.this.zzAq.zzeO();
                }
            }
        });
        this.zzt(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.zzAc.zzb(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = zzc.getDefaultSize((int)this.zzAh, (int)widthMeasureSpec);
        int n2 = zzc.getDefaultSize((int)this.zzAi, (int)heightMeasureSpec);
        if (this.zzAh > 0 && this.zzAi > 0) {
            int n3 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n6 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (n3 == 0x40000000 && n5 == 0x40000000) {
                n2 = n6;
                n = n4;
                if (this.zzAh * n2 < n * this.zzAi) {
                    n = n2 * this.zzAh / this.zzAi;
                } else if (this.zzAh * n2 > n * this.zzAi) {
                    n2 = n * this.zzAi / this.zzAh;
                }
            } else if (n3 == 0x40000000) {
                n = n4;
                n2 = n * this.zzAi / this.zzAh;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                }
            } else if (n5 == 0x40000000) {
                n2 = n6;
                n = n2 * this.zzAh / this.zzAi;
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                }
            } else {
                n = this.zzAh;
                n2 = this.zzAi;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                    n = n2 * this.zzAh / this.zzAi;
                }
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                    n2 = n * this.zzAi / this.zzAh;
                }
            }
        }
        this.setMeasuredDimension(n, n2);
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzAk > 0 && this.zzAk != n || this.zzAl > 0 && this.zzAl != n2) {
                this.zzem();
            }
            this.zzAk = n;
            this.zzAl = n2;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private void zzel() {
        zzb.v("AdVideoView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzAg == null || surfaceTexture == null) {
            return;
        }
        this.zzt(false);
        try {
            this.zzAf = new MediaPlayer();
            this.zzAf.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzAf.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzAf.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzAf.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzAf.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzAf.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzAj = 0;
            this.zzAf.setDataSource(this.getContext(), this.zzAg);
            this.zzAf.setSurface(new Surface(surfaceTexture));
            this.zzAf.setAudioStreamType(3);
            this.zzAf.setScreenOnWhilePlaying(true);
            this.zzAf.prepareAsync();
            this.zzt(1);
        }
        catch (IOException | IllegalArgumentException exception) {
            zzb.zzd("Failed to initialize MediaPlayer at " + this.zzAg, exception);
            this.onError(this.zzAf, 1, 0);
        }
    }

    private void zzem() {
        if (this.zzep() && this.zzAf.getCurrentPosition() > 0 && this.zzAe != 3) {
            long l;
            zzb.v("AdVideoView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzAf.start();
            int n = this.zzAf.getCurrentPosition();
            long l2 = com.google.android.gms.ads.internal.zzp.zzbB().currentTimeMillis();
            while (this.zzep() && this.zzAf.getCurrentPosition() == n && (l = com.google.android.gms.ads.internal.zzp.zzbB().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzAf.pause();
            this.zzeu();
        }
    }

    private void zzen() {
        AudioManager audioManager = this.zzev();
        if (audioManager != null && !this.zzAo) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzes();
            } else {
                zzb.zzaE("AdVideoView audio focus request failed");
            }
        }
    }

    private void zzeo() {
        zzb.v("AdVideoView abandon audio focus");
        AudioManager audioManager = this.zzev();
        if (audioManager != null && this.zzAo) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzAo = false;
            } else {
                zzb.zzaE("AdVideoView abandon audio focus failed");
            }
        }
    }

    private void zzt(boolean bl) {
        zzb.v("AdVideoView release");
        if (this.zzAf != null) {
            this.zzAf.reset();
            this.zzAf.release();
            this.zzAf = null;
            this.zzt(0);
            if (bl) {
                this.zzAe = 0;
                this.zzu(0);
            }
            this.zzeo();
        }
    }

    @Override
    public void play() {
        zzb.v("AdVideoView play");
        if (this.zzep()) {
            this.zzAf.start();
            this.zzt(3);
            zzhu.zzHK.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzAq != null) {
                        zzc.this.zzAq.zzeM();
                    }
                }
            });
        }
        this.zzu(3);
    }

    @Override
    public void pause() {
        zzb.v("AdVideoView pause");
        if (this.zzep() && this.zzAf.isPlaying()) {
            this.zzAf.pause();
            this.zzt(4);
            zzhu.zzHK.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzAq != null) {
                        zzc.this.zzAq.onPaused();
                    }
                }
            });
        }
        this.zzu(4);
    }

    @Override
    public int getDuration() {
        if (this.zzep()) {
            return this.zzAf.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzep()) {
            return this.zzAf.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int millis) {
        zzb.v("AdVideoView seek " + millis);
        if (this.zzep()) {
            this.zzAf.seekTo(millis);
            this.zzAp = 0;
        } else {
            this.zzAp = millis;
        }
    }

    private boolean zzep() {
        return this.zzAf != null && this.zzAd != -1 && this.zzAd != 0 && this.zzAd != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange > 0) {
            this.zzes();
        } else if (focusChange < 0) {
            this.zzet();
        }
    }

    @Override
    public void zzeq() {
        this.zzAn = true;
        this.zzeu();
    }

    @Override
    public void zzer() {
        this.zzAn = false;
        this.zzeu();
    }

    @Override
    public void zza(float f) {
        this.zzAm = f;
        this.zzeu();
    }

    @Override
    public int getVideoWidth() {
        if (this.zzAf != null) {
            return this.zzAf.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzAf != null) {
            return this.zzAf.getVideoHeight();
        }
        return 0;
    }

    private void zzes() {
        zzb.v("AdVideoView audio focus gained");
        this.zzAo = true;
        this.zzeu();
    }

    private void zzet() {
        zzb.v("AdVideoView audio focus lost");
        this.zzAo = false;
        this.zzeu();
    }

    private void zzeu() {
        if (!this.zzAn && this.zzAo) {
            this.zzb(this.zzAm);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzAf != null) {
            try {
                this.zzAf.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzb.zzaE("AdVideoView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzev() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzt(int n) {
        if (n == 3) {
            this.zzAc.zzeY();
        } else if (this.zzAd == 3 && n != 3) {
            this.zzAc.zzeZ();
        }
        this.zzAd = n;
    }

    private void zzu(int n) {
        this.zzAe = n;
    }

    static {
        zzAb.put(-1004, "MEDIA_ERROR_IO");
        zzAb.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzAb.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzAb.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzAb.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzAb.put(1, "MEDIA_ERROR_UNKNOWN");
        zzAb.put(1, "MEDIA_INFO_UNKNOWN");
        zzAb.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzAb.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzAb.put(701, "MEDIA_INFO_BUFFERING_START");
        zzAb.put(702, "MEDIA_INFO_BUFFERING_END");
        zzAb.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzAb.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzAb.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzAb.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzAb.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

