/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzau;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.internal.zzax;
import com.google.android.gms.wearable.internal.zzbi;
import com.google.android.gms.wearable.internal.zzbm;
import com.google.android.gms.wearable.internal.zzbo;
import com.google.android.gms.wearable.internal.zzs;
import com.google.android.gms.wearable.zza;
import com.google.android.gms.wearable.zzc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzbn
extends zzj<zzaw> {
    private final ExecutorService zzaRv = Executors.newCachedThreadPool();
    private final zzax<zzc.zza> zzbaU = new zzax();
    private final zzax<zza.zza> zzbaV = new zzax();
    private final zzax<ChannelApi.ChannelListener> zzbaW = new zzax();
    private final zzax<DataApi.DataListener> zzbaX = new zzax();
    private final zzax<MessageApi.MessageListener> zzbaY = new zzax();
    private final zzax<NodeApi.NodeListener> zzbaZ = new zzax();
    private final zzax<NodeApi.zza> zzbba = new zzax();
    private final Map<String, zzax<CapabilityApi.CapabilityListener>> zzbbb = new HashMap<String, zzax<CapabilityApi.CapabilityListener>>();

    public zzbn(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzf zzf2) {
        super(context, looper, 14, zzf2, connectionCallbacks, onConnectionFailedListener);
    }

    protected String zzfA() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected String zzfB() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected zzaw zzec(IBinder iBinder) {
        return zzaw.zza.zzea(iBinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n));
        }
        if (n == 0) {
            this.zzbaU.zzeb(iBinder);
            this.zzbaV.zzeb(iBinder);
            this.zzbaX.zzeb(iBinder);
            this.zzbaY.zzeb(iBinder);
            this.zzbaZ.zzeb(iBinder);
            this.zzbba.zzeb(iBinder);
            Map<String, zzax<CapabilityApi.CapabilityListener>> map = this.zzbbb;
            synchronized (map) {
                for (zzax<CapabilityApi.CapabilityListener> zzax2 : this.zzbbb.values()) {
                    zzax2.zzeb(iBinder);
                }
            }
        }
        super.zza(n, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzbaU.zzb(this);
        this.zzbaV.zzb(this);
        this.zzbaX.zzb(this);
        this.zzbaY.zzb(this);
        this.zzbaZ.zzb(this);
        this.zzbba.zzb(this);
        Map<String, zzax<CapabilityApi.CapabilityListener>> map = this.zzbbb;
        synchronized (map) {
            for (zzax<CapabilityApi.CapabilityListener> zzax2 : this.zzbbb.values()) {
                zzax2.zzb(this);
            }
        }
        super.disconnect();
    }

    public void zza(zzc.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzo(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            ParcelFileDescriptor[] parcelFileDescriptorArray;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() == null) {
                putDataRequest2.putAsset((String)entry3.getKey(), (Asset)entry3.getValue());
                continue;
            }
            try {
                parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
            }
            if (Log.isLoggable((String)"WearableClient", (int)3)) {
                Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptorArray[0] + " write:" + parcelFileDescriptorArray[1]));
            }
            putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
            FutureTask<Boolean> futureTask = this.zza(parcelFileDescriptorArray[1], asset.getData());
            entry22.add(futureTask);
            this.zzaRv.submit(futureTask);
        }
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean zzCI() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzCI();
            }
        });
    }

    public void zza(zzc.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzk(zzb2), uri);
    }

    public void zzn(zzc.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzaw)this.zzoA()).zzb(new zzbm.zzl(zzb2));
    }

    public void zza(zzc.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzl(zzb2), uri, n);
    }

    public void zzb(zzc.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzaw)this.zzoA()).zzb((zzau)new zzbm.zze(zzb2), uri, n);
    }

    public void zza(zzc.zzb<MessageApi.SendMessageResult> zzb2, String string, String string2, byte[] byArray) throws RemoteException {
        ((zzaw)this.zzoA()).zza(new zzbm.zzt(zzb2), string, string2, byArray);
    }

    public void zza(zzc.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzm(zzb2), asset);
    }

    public void zza(zzc.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzo(zzc.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzaw)this.zzoA()).zzc(new zzbm.zzn(zzb2));
    }

    public void zzp(zzc.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzaw)this.zzoA()).zzd(new zzbm.zzj(zzb2));
    }

    public void zzg(zzc.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string, int n) throws RemoteException {
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzg(zzb2), string, n);
    }

    public void zzd(zzc.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzf(zzb2), n);
    }

    public void zzr(zzc.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzaw)this.zzoA()).zzd(new zzbm.zza(zzb2), string);
    }

    public void zzs(zzc.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzaw)this.zzoA()).zze(new zzbm.zzs(zzb2), string);
    }

    public void zze(zzc.zzb<ChannelApi.OpenChannelResult> zzb2, String string, String string2) throws RemoteException {
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzp(zzb2), string, string2);
    }

    public void zzt(zzc.zzb<Status> zzb2, String string) throws RemoteException {
        ((zzaw)this.zzoA()).zzf(new zzbm.zzc(zzb2), string);
    }

    public void zzh(zzc.zzb<Status> zzb2, String string, int n) throws RemoteException {
        ((zzaw)this.zzoA()).zzb((zzau)new zzbm.zzd(zzb2), string, n);
    }

    public void zzu(zzc.zzb<Channel.GetInputStreamResult> zzb2, String string) throws RemoteException {
        zzs zzs2 = new zzs();
        ((zzaw)this.zzoA()).zza((zzau)new zzbm.zzh(zzb2, zzs2), zzs2, string);
    }

    public void zzv(zzc.zzb<Channel.GetOutputStreamResult> zzb2, String string) throws RemoteException {
        zzs zzs2 = new zzs();
        ((zzaw)this.zzoA()).zzb((zzau)new zzbm.zzi(zzb2, zzs2), zzs2, string);
    }

    public void zza(zzc.zzb<Status> zzb2, String string, Uri uri, boolean bl) {
        try {
            FutureTask<Void> futureTask = this.zzb(zzb2, string, uri, bl);
            this.zzaRv.submit(futureTask);
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzx(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzc.zzb<Status> zzb2, String string, Uri uri, long l, long l2) {
        try {
            FutureTask<Void> futureTask = this.zzb(zzb2, string, uri, l, l2);
            this.zzaRv.submit(futureTask);
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzx(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzc.zzb<Status> zzb2, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbaX.zza(this, zzb2, dataListener, zzbo.zza(dataListener, intentFilterArray));
    }

    public void zza(zzc.zzb<Status> zzb2, MessageApi.MessageListener messageListener, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbaY.zza(this, zzb2, messageListener, zzbo.zza(messageListener, intentFilterArray));
    }

    public void zza(zzc.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbaZ.zza(this, zzb2, nodeListener, zzbo.zza(nodeListener));
    }

    private zzax<CapabilityApi.CapabilityListener> zzfw(String string) {
        zzax<CapabilityApi.CapabilityListener> zzax2 = this.zzbbb.get(string);
        if (zzax2 == null) {
            zzax2 = new zzax();
            this.zzbbb.put(string, zzax2);
        }
        return zzax2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzc.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, String string) throws RemoteException {
        Map<String, zzax<CapabilityApi.CapabilityListener>> map = this.zzbbb;
        synchronized (map) {
            this.zzfw(string).zza(this, zzb2, capabilityListener, zzbo.zza(capabilityListener, string));
        }
    }

    public void zza(zzc.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzbaW.zza(this, zzb2, channelListener, zzbo.zzb(channelListener));
        } else {
            zzbi zzbi2 = new zzbi(string, channelListener);
            this.zzbaW.zza(this, zzb2, zzbi2, zzbo.zza(zzbi2, string));
        }
    }

    public void zza(zzc.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzbaX.zza(this, zzb2, dataListener);
    }

    public void zza(zzc.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzbaY.zza(this, zzb2, messageListener);
    }

    public void zzb(zzc.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbaZ.zza(this, zzb2, nodeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzb(zzc.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, String string) throws RemoteException {
        Map<String, zzax<CapabilityApi.CapabilityListener>> map = this.zzbbb;
        synchronized (map) {
            zzax<CapabilityApi.CapabilityListener> zzax2 = this.zzfw(string);
            zzax2.zza(this, zzb2, capabilityListener);
            if (zzax2.isEmpty()) {
                this.zzbbb.remove(string);
            }
        }
    }

    public void zzb(zzc.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzbaW.zza(this, zzb2, channelListener);
        } else {
            zzbi zzbi2 = new zzbi(string, channelListener);
            this.zzbaW.zza(this, zzb2, zzbi2);
        }
    }

    private FutureTask<Void> zzb(final zzc.zzb<Status> zzb2, final String string, final Uri uri, final boolean bl) {
        zzx.zzv(zzb2);
        zzx.zzv((Object)string);
        zzx.zzv((Object)uri);
        return new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzx(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x20000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.receiveFile: " + file));
                    zzb2.zzx(new Status(13));
                    return;
                }
                try {
                    ((zzaw)zzbn.this.zzoA()).zza((zzau)new zzbm.zzu((zzc.zzb<Status>)zzb2), string, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzx(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        }, null);
    }

    private FutureTask<Void> zzb(final zzc.zzb<Status> zzb2, final String string, final Uri uri, final long l, final long l2) {
        zzx.zzv(zzb2);
        zzx.zzv((Object)string);
        zzx.zzv((Object)uri);
        zzx.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzx.zzb((l2 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzx(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.sendFile: " + file));
                    zzb2.zzx(new Status(13));
                    return;
                }
                try {
                    ((zzaw)zzbn.this.zzoA()).zza(new zzbm.zzr((zzc.zzb<Status>)zzb2), string, parcelFileDescriptor, l, l2);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzx(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        }, null);
    }

    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzec(iBinder);
    }
}

