/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int mVersionCode;
    private final long zzMS;
    private final long zzann;
    private final Session zzanp;
    private final int zzanx;
    private final List<DataSet> zzany;
    private final int zzanz;
    private boolean zzanA = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzc();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzanp = session;
        this.zzanx = activityType;
        this.zzany = dataSets;
        this.zzanz = bucketType;
        this.zzanA = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources) {
        this(2, bucket.zzMS, bucket.zzann, bucket.zzanp, bucket.zzaov, Bucket.zza(bucket.zzany, uniqueDataSources), bucket.zzanz, bucket.zzanA);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzMS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzann, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzanp;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzanx);
    }

    public int zzru() {
        return this.zzanx;
    }

    public List<DataSet> getDataSets() {
        return this.zzany;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzany) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzanz;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Bucket && this.zza((Bucket)o);
    }

    private boolean zza(Bucket bucket) {
        return this.zzMS == bucket.zzMS && this.zzann == bucket.zzann && this.zzanx == bucket.zzanx && zzw.equal(this.zzany, bucket.zzany) && this.zzanz == bucket.zzanz && this.zzanA == bucket.zzanA;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzMS == bucket.zzMS && this.zzann == bucket.zzann && this.zzanx == bucket.zzanx && this.zzanz == bucket.zzanz;
    }

    public boolean zzrv() {
        if (this.zzanA) {
            return true;
        }
        for (DataSet dataSet : this.zzany) {
            if (!dataSet.zzrv()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzMS, this.zzann, this.zzanx, this.zzanz});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("startTime", (Object)this.zzMS).zzg("endTime", (Object)this.zzann).zzg("activity", (Object)this.zzanx).zzg("dataSets", this.zzany).zzg("bucketType", (Object)Bucket.zzel(this.zzanz)).zzg("serverHasMoreData", (Object)this.zzanA).toString();
    }

    public static String zzel(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzkH() {
        return this.zzMS;
    }

    public long zzrw() {
        return this.zzann;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

