/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.api.zzp;
import com.google.android.gms.common.api.zzq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.signin.zzb;
import com.google.android.gms.signin.zzd;
import com.google.android.gms.signin.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.zzb, R extends Result, T extends zzc.zza<R, A>> T zza(T var1);

    public <A extends Api.zzb, T extends zzc.zza<? extends Result, A>> T zzb(T var1);

    public <L> zzl<L> zzp(L var1);

    public <C extends Api.zzb> C zza(Api.zzc<C> var1);

    public boolean zza(Api<?> var1);

    public boolean hasConnectedApi(Api<?> var1);

    public ConnectionResult getConnectionResult(Api<?> var1);

    public boolean zza(Scope var1);

    public Context getContext();

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public PendingResult<Status> clearDefaultAccountAndReconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    @Deprecated
    public int getSessionId();

    public static final class Builder {
        private Account zzOY;
        private final Set<Scope> zzYY = new HashSet<Scope>();
        private int zzYZ;
        private View zzZa;
        private String zzQl;
        private String zzZb;
        private final Map<Api<?>, zzf.zza> zzZc = new zzld();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzZd = new zzld();
        private FragmentActivity zzZe;
        private int zzZf = -1;
        private int zzZg = -1;
        private OnConnectionFailedListener zzZh;
        private Looper zzYV;
        private GoogleApiAvailability zzZi = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzd, zze> zzZj = zzb.zzQg;
        private final ArrayList<ConnectionCallbacks> zzZk = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzZl = new ArrayList();
        private zze.zza zzZm = new zze.zza();

        public Builder(Context context) {
            this.mContext = context;
            this.zzYV = context.getMainLooper();
            this.zzQl = context.getPackageName();
            this.zzZb = context.getClass().getName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            zzx.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzZk.add(connectedListener);
            zzx.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzZl.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            zzx.zzb(handler, (Object)"Handler must not be null");
            this.zzYV = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.zzZk.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.zzZl.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.zzZa = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.zzYY.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.zzZd.put(api, null);
            this.zzYY.addAll(api.zznb().zzl(null));
            return this;
        }

        public Builder addApiIfAvailable(Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopes) {
            this.zzZd.put(api, null);
            this.zza(api, null, 1, scopes);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzZd.put(api, options);
            this.zzYY.addAll(api.zznb().zzl(options));
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(Api<O> api, O options, Scope ... scopes) {
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzZd.put(api, options);
            this.zza(api, options, 1, scopes);
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzOY = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzYZ = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            zzx.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzZf = clientId;
            this.zzZe = zzx.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzZh = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder requestServerAuthCode(String serverClientId, ServerAuthCodeCallbacks callbacks) {
            this.zzZm.zza(serverClientId, callbacks);
            return this;
        }

        public zzf zzni() {
            return new zzf(this.zzOY, this.zzYY, this.zzZc, this.zzYZ, this.zzZa, this.zzQl, this.zzZb, this.zzZm.zzzr());
        }

        public GoogleApiClient build() {
            zzx.zzb(!this.zzZd.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.zzZf >= 0) {
                return this.zznj();
            }
            if (this.zzZg >= 0) {
                return this.zznk();
            }
            return new zzi(this.mContext, this.zzYV, this.zzni(), this.zzZi, this.zzZj, this.zzZd, this.zzZk, this.zzZl, -1, -1);
        }

        private GoogleApiClient zznj() {
            final zzi zzi2 = new zzi(this.mContext.getApplicationContext(), this.zzYV, this.zzni(), this.zzZi, this.zzZj, this.zzZd, this.zzZk, this.zzZl, this.zzZf, -1);
            zzp zzp2 = zzp.zza(this.zzZe);
            if (zzp2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Builder.this.zzZe.isFinishing() || Builder.this.zzZe.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        Builder.this.zza(zzp.zzb(Builder.this.zzZe), zzi2);
                    }
                });
            } else {
                this.zza(zzp2, zzi2);
            }
            return zzi2;
        }

        private void zza(zzp zzp2, GoogleApiClient googleApiClient) {
            zzp2.zza(this.zzZf, googleApiClient, this.zzZh);
        }

        private GoogleApiClient zznk() {
            zzq zzq2 = zzq.zzc(this.zzZe);
            GoogleApiClient googleApiClient = zzq2.zzbj(this.zzZg);
            if (googleApiClient == null) {
                googleApiClient = new zzi(this.mContext.getApplicationContext(), this.zzYV, this.zzni(), this.zzZi, this.zzZj, this.zzZd, this.zzZk, this.zzZl, -1, this.zzZg);
            }
            zzq2.zza(this.zzZg, googleApiClient, this.zzZh);
            return googleApiClient;
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid resolution mode: '" + n + "', use a constant from GoogleApiClient.ResolutionMode");
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zznb().zzl(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzZc.put(api, new zzf.zza(hashSet, bl));
        }
    }

    public static interface zza {
        public void zza(ConnectionResult var1);

        public void zzb(ConnectionResult var1);
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzZo;
            private Set<Scope> zzZp;

            public static CheckResult newAuthNotRequiredResult() {
                return new CheckResult(false, null);
            }

            public static CheckResult newAuthRequiredResult(Set<Scope> requiredScopes) {
                zzx.zzb(requiredScopes != null && !requiredScopes.isEmpty(), (Object)"A non-empty scope set is required if further auth is needed.");
                return new CheckResult(true, requiredScopes);
            }

            private CheckResult(boolean requiresNewAuthCode, Set<Scope> requiredScopes) {
                this.zzZo = requiresNewAuthCode;
                this.zzZp = requiredScopes;
            }

            public boolean zznl() {
                return this.zzZo;
            }

            public Set<Scope> zznm() {
                return this.zzZp;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

