/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzy;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;

public class zzz
implements zzy {
    private final zza zzaE;
    private final SSLSocketFactory zzaF;

    public zzz() {
        this(null);
    }

    public zzz(zza zza2) {
        this(zza2, null);
    }

    public zzz(zza zza2, SSLSocketFactory sSLSocketFactory) {
        this.zzaE = zza2;
        this.zzaF = sSLSocketFactory;
    }

    @Override
    public HttpResponse zza(zzk<?> zzk2, Map<String, String> map) throws IOException, com.google.android.gms.internal.zza {
        Object object;
        Object object2 = zzk2.getUrl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(zzk2.getHeaders());
        hashMap.putAll(map);
        if (this.zzaE != null) {
            object = this.zzaE.zzh((String)object2);
            if (object == null) {
                throw new IOException("URL blocked by rewriter: " + (String)object2);
            }
            object2 = object;
        }
        object = new URL((String)object2);
        HttpURLConnection httpURLConnection = this.zza((URL)object, zzk2);
        for (String string2 : hashMap.keySet()) {
            httpURLConnection.addRequestProperty(string2, (String)hashMap.get(string2));
        }
        zzz.zza(httpURLConnection, zzk2);
        ProtocolVersion protocolVersion = new ProtocolVersion("HTTP", 1, 1);
        int n = httpURLConnection.getResponseCode();
        if (n == -1) {
            throw new IOException("Could not retrieve response code from HttpUrlConnection.");
        }
        BasicStatusLine basicStatusLine = new BasicStatusLine(protocolVersion, httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage());
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse((StatusLine)basicStatusLine);
        basicHttpResponse.setEntity(zzz.zza(httpURLConnection));
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            if (entry.getKey() == null) continue;
            BasicHeader basicHeader = new BasicHeader(entry.getKey(), entry.getValue().get(0));
            basicHttpResponse.addHeader((Header)basicHeader);
        }
        return basicHttpResponse;
    }

    private static HttpEntity zza(HttpURLConnection httpURLConnection) {
        InputStream inputStream;
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        try {
            inputStream = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            inputStream = httpURLConnection.getErrorStream();
        }
        basicHttpEntity.setContent(inputStream);
        basicHttpEntity.setContentLength((long)httpURLConnection.getContentLength());
        basicHttpEntity.setContentEncoding(httpURLConnection.getContentEncoding());
        basicHttpEntity.setContentType(httpURLConnection.getContentType());
        return basicHttpEntity;
    }

    protected HttpURLConnection zza(URL uRL) throws IOException {
        return (HttpURLConnection)uRL.openConnection();
    }

    private HttpURLConnection zza(URL uRL, zzk<?> zzk2) throws IOException {
        HttpURLConnection httpURLConnection = this.zza(uRL);
        int n = zzk2.zzt();
        httpURLConnection.setConnectTimeout(n);
        httpURLConnection.setReadTimeout(n);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        if ("https".equals(uRL.getProtocol()) && this.zzaF != null) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.zzaF);
        }
        return httpURLConnection;
    }

    static void zza(HttpURLConnection httpURLConnection, zzk<?> zzk2) throws IOException, com.google.android.gms.internal.zza {
        switch (zzk2.getMethod()) {
            case -1: {
                byte[] byArray = zzk2.zzm();
                if (byArray == null) break;
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.addRequestProperty("Content-Type", zzk2.zzl());
                DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                dataOutputStream.write(byArray);
                dataOutputStream.close();
                break;
            }
            case 0: {
                httpURLConnection.setRequestMethod("GET");
                break;
            }
            case 3: {
                httpURLConnection.setRequestMethod("DELETE");
                break;
            }
            case 1: {
                httpURLConnection.setRequestMethod("POST");
                zzz.zzb(httpURLConnection, zzk2);
                break;
            }
            case 2: {
                httpURLConnection.setRequestMethod("PUT");
                zzz.zzb(httpURLConnection, zzk2);
                break;
            }
            case 4: {
                httpURLConnection.setRequestMethod("HEAD");
                break;
            }
            case 5: {
                httpURLConnection.setRequestMethod("OPTIONS");
                break;
            }
            case 6: {
                httpURLConnection.setRequestMethod("TRACE");
                break;
            }
            case 7: {
                httpURLConnection.setRequestMethod("PATCH");
                zzz.zzb(httpURLConnection, zzk2);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static void zzb(HttpURLConnection httpURLConnection, zzk<?> zzk2) throws IOException, com.google.android.gms.internal.zza {
        byte[] byArray = zzk2.zzq();
        if (byArray != null) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Type", zzk2.zzp());
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.write(byArray);
            dataOutputStream.close();
        }
    }

    public static interface zza {
        public String zzh(String var1);
    }
}

