/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.zzgk;
import java.util.Locale;

@zzgk
public final class zzgr {
    public final int zzFB;
    public final boolean zzFC;
    public final boolean zzFD;
    public final String zzFE;
    public final String zzFF;
    public final boolean zzFG;
    public final boolean zzFH;
    public final boolean zzFI;
    public final boolean zzFJ;
    public final String zzFK;
    public final String zzFL;
    public final int zzFM;
    public final int zzFN;
    public final int zzFO;
    public final int zzFP;
    public final int zzFQ;
    public final int zzFR;
    public final float zzDK;
    public final int zzDI;
    public final int zzDJ;
    public final double zzFS;
    public final boolean zzFT;
    public final boolean zzFU;
    public final int zzFV;
    public final String zzFW;

    zzgr(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6) {
        this.zzFB = n;
        this.zzFC = bl;
        this.zzFD = bl2;
        this.zzFE = string2;
        this.zzFF = string3;
        this.zzFG = bl3;
        this.zzFH = bl4;
        this.zzFI = bl5;
        this.zzFJ = bl6;
        this.zzFK = string4;
        this.zzFL = string5;
        this.zzFM = n2;
        this.zzFN = n3;
        this.zzFO = n4;
        this.zzFP = n5;
        this.zzFQ = n6;
        this.zzFR = n7;
        this.zzDK = f;
        this.zzDI = n8;
        this.zzDJ = n9;
        this.zzFS = d;
        this.zzFT = bl7;
        this.zzFU = bl8;
        this.zzFV = n10;
        this.zzFW = string6;
    }

    public static final class zza {
        private int zzFB;
        private boolean zzFI;
        private boolean zzFJ;
        private int zzFM;
        private int zzFQ;
        private int zzFR;
        private String zzFE;
        private int zzFN;
        private int zzFO;
        private int zzFP;
        private boolean zzFU;
        private int zzFV;
        private double zzFS;
        private boolean zzFT;
        private String zzFW;
        private boolean zzFC;
        private boolean zzFD;
        private String zzFF;
        private boolean zzFG;
        private boolean zzFH;
        private String zzFK;
        private String zzFL;
        private float zzDK;
        private int zzDI;
        private int zzDJ;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzA(context);
            this.zza(context, packageManager);
            this.zzB(context);
            Locale locale = Locale.getDefault();
            this.zzFC = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzFD = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzFF = locale.getCountry();
            this.zzFG = zzk.zzcE().zzgH();
            this.zzFH = GooglePlayServicesUtil.zzag((Context)context);
            this.zzFK = locale.getLanguage();
            this.zzFL = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzDK = displayMetrics.density;
            this.zzDI = displayMetrics.widthPixels;
            this.zzDJ = displayMetrics.heightPixels;
        }

        public zza(Context context, zzgr zzgr2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzA(context);
            this.zza(context, packageManager);
            this.zzB(context);
            this.zzC(context);
            this.zzFC = zzgr2.zzFC;
            this.zzFD = zzgr2.zzFD;
            this.zzFF = zzgr2.zzFF;
            this.zzFG = zzgr2.zzFG;
            this.zzFH = zzgr2.zzFH;
            this.zzFK = zzgr2.zzFK;
            this.zzFL = zzgr2.zzFL;
            this.zzDK = zzgr2.zzDK;
            this.zzDI = zzgr2.zzDI;
            this.zzDJ = zzgr2.zzDJ;
        }

        private void zzA(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            this.zzFB = audioManager.getMode();
            this.zzFI = audioManager.isMusicActive();
            this.zzFJ = audioManager.isSpeakerphoneOn();
            this.zzFM = audioManager.getStreamVolume(3);
            this.zzFQ = audioManager.getRingerMode();
            this.zzFR = audioManager.getStreamVolume(2);
        }

        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzFE = telephonyManager.getNetworkOperator();
            this.zzFN = zza.zza(context, connectivityManager, packageManager);
            this.zzFO = telephonyManager.getNetworkType();
            this.zzFP = telephonyManager.getPhoneType();
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzFU = connectivityManager.isActiveNetworkMetered();
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                this.zzFV = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
            } else {
                this.zzFU = false;
                this.zzFV = -1;
            }
        }

        private void zzB(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzFS = (float)n2 / (float)n3;
                this.zzFT = n == 2 || n == 5;
            } else {
                this.zzFS = -1.0;
                this.zzFT = false;
            }
        }

        private void zzC(Context context) {
            this.zzFW = Build.FINGERPRINT;
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static int zza(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
            int n = -2;
            if (zzp.zzbx().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                n = networkInfo != null ? networkInfo.getType() : -1;
            }
            return n;
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzgr zzfN() {
            return new zzgr(this.zzFB, this.zzFC, this.zzFD, this.zzFE, this.zzFF, this.zzFG, this.zzFH, this.zzFI, this.zzFJ, this.zzFK, this.zzFL, this.zzFM, this.zzFN, this.zzFO, this.zzFP, this.zzFQ, this.zzFR, this.zzDK, this.zzDI, this.zzDJ, this.zzFS, this.zzFT, this.zzFU, this.zzFV, this.zzFW);
        }
    }
}

