/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.places.zzb;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddPlaceRequest
implements SafeParcelable {
    final int mVersionCode;
    private final String mName;
    private final LatLng zzaDh;
    private final String zzanu;
    private final List<Integer> zzaDi;
    private final String zzaDj;
    private final Uri zzaDk;
    public static final Parcelable.Creator<AddPlaceRequest> CREATOR = new zzb();

    AddPlaceRequest(int versionCode, String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri websiteUri) {
        this.mVersionCode = versionCode;
        this.mName = zzx.zzcs((String)name);
        this.zzaDh = (LatLng)zzx.zzv((Object)latLng);
        this.zzanu = zzx.zzcs((String)address);
        this.zzaDi = new ArrayList<Integer>((Collection)zzx.zzv(placeTypes));
        zzx.zzb((!this.zzaDi.isEmpty() ? 1 : 0) != 0, (Object)"At least one place type should be provided.");
        zzx.zzb((!TextUtils.isEmpty((CharSequence)phoneNumber) || websiteUri != null ? 1 : 0) != 0, (Object)"One of phone number or URI should be provided.");
        this.zzaDj = phoneNumber;
        this.zzaDk = websiteUri;
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber) {
        this(name, latLng, address, placeTypes, zzx.zzcs((String)phoneNumber), null);
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, Uri uri) {
        this(name, latLng, address, placeTypes, null, (Uri)zzx.zzv((Object)uri));
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri uri) {
        this(0, name, latLng, address, placeTypes, phoneNumber, uri);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzb.zza(this, parcel, flags);
    }

    public String getName() {
        return this.mName;
    }

    public LatLng getLatLng() {
        return this.zzaDh;
    }

    public String getAddress() {
        return this.zzanu;
    }

    public List<Integer> getPlaceTypes() {
        return this.zzaDi;
    }

    public String getPhoneNumber() {
        return this.zzaDj;
    }

    public Uri getWebsiteUri() {
        return this.zzaDk;
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("name", (Object)this.mName).zzg("latLng", (Object)this.zzaDh).zzg("address", (Object)this.zzanu).zzg("placeTypes", this.zzaDi).zzg("phoneNumer", (Object)this.zzaDj).zzg("websiteUri", (Object)this.zzaDk).toString();
    }
}

