/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.SessionsApi;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.request.SessionRegistrationRequest;
import com.google.android.gms.fitness.request.SessionStartRequest;
import com.google.android.gms.fitness.request.SessionStopRequest;
import com.google.android.gms.fitness.request.SessionUnregistrationRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznf;
import com.google.android.gms.internal.zzng;
import com.google.android.gms.internal.zznt;
import java.util.concurrent.TimeUnit;

public class zzns
implements SessionsApi {
    @Override
    public PendingResult<Status> startSession(GoogleApiClient client, final Session session) {
        zzx.zzb((Object)session, (Object)"Session cannot be null");
        zzx.zzb((session.getEndTime(TimeUnit.MILLISECONDS) == 0L ? 1 : 0) != 0, (Object)"Cannot start a session which has already ended");
        return client.zzb((zzc.zza)new zzmq.zzc(client){

            protected void zza(zzmq zzmq2) throws RemoteException {
                zznt zznt2 = new zznt((zzc.zzb<Status>)this);
                String string = zzmq2.getContext().getPackageName();
                ((zznb)zzmq2.zzoA()).zza(new SessionStartRequest(session, zznt2, string));
            }
        });
    }

    private PendingResult<SessionStopResult> zza(GoogleApiClient googleApiClient, final String string, final String string2) {
        return googleApiClient.zzb((zzc.zza)new zzmq.zza<SessionStopResult>(googleApiClient){

            protected void zza(zzmq zzmq2) throws RemoteException {
                zzb zzb2 = new zzb((zzc.zzb)this);
                String string3 = zzmq2.getContext().getPackageName();
                ((zznb)zzmq2.zzoA()).zza(new SessionStopRequest(string, string2, zzb2, string3));
            }

            protected SessionStopResult zzN(Status status) {
                return SessionStopResult.zzV(status);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzN(status);
            }
        });
    }

    @Override
    public PendingResult<SessionStopResult> stopSession(GoogleApiClient client, String identifier) {
        String string = null;
        return this.zza(client, string, identifier);
    }

    @Override
    public PendingResult<Status> insertSession(GoogleApiClient client, final SessionInsertRequest request) {
        return client.zza((zzc.zza)new zzmq.zzc(client){

            protected void zza(zzmq zzmq2) throws RemoteException {
                zznt zznt2 = new zznt((zzc.zzb<Status>)this);
                String string = zzmq2.getContext().getPackageName();
                ((zznb)zzmq2.zzoA()).zza(new SessionInsertRequest(request, zznt2, string));
            }
        });
    }

    @Override
    public PendingResult<SessionReadResult> readSession(GoogleApiClient client, final SessionReadRequest request) {
        return client.zza((zzc.zza)new zzmq.zza<SessionReadResult>(client){

            protected void zza(zzmq zzmq2) throws RemoteException {
                zza zza2 = new zza((zzc.zzb)this);
                String string = zzmq2.getContext().getPackageName();
                ((zznb)zzmq2.zzoA()).zza(new SessionReadRequest(request, zza2, string));
            }

            protected SessionReadResult zzO(Status status) {
                return SessionReadResult.zzU(status);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzO(status);
            }
        });
    }

    @Override
    public PendingResult<Status> registerForSessions(GoogleApiClient client, PendingIntent intent) {
        return this.zza(client, intent, 0);
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final int n) {
        return googleApiClient.zzb((zzc.zza)new zzmq.zzc(googleApiClient){

            protected void zza(zzmq zzmq2) throws RemoteException {
                zznt zznt2 = new zznt((zzc.zzb<Status>)this);
                String string = zzmq2.getContext().getPackageName();
                ((zznb)zzmq2.zzoA()).zza(new SessionRegistrationRequest(pendingIntent, zznt2, string, n));
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterForSessions(GoogleApiClient client, final PendingIntent intent) {
        return client.zzb((zzc.zza)new zzmq.zzc(client){

            protected void zza(zzmq zzmq2) throws RemoteException {
                zznt zznt2 = new zznt((zzc.zzb<Status>)this);
                String string = zzmq2.getContext().getPackageName();
                ((zznb)zzmq2.zzoA()).zza(new SessionUnregistrationRequest(intent, zznt2, string));
            }
        });
    }

    private static class zza
    extends zznf.zza {
        private final zzc.zzb<SessionReadResult> zzQz;

        private zza(zzc.zzb<SessionReadResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(SessionReadResult sessionReadResult) throws RemoteException {
            this.zzQz.zzn((Object)sessionReadResult);
        }
    }

    private static class zzb
    extends zzng.zza {
        private final zzc.zzb<SessionStopResult> zzQz;

        private zzb(zzc.zzb<SessionStopResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(SessionStopResult sessionStopResult) {
            this.zzQz.zzn((Object)sessionStopResult);
        }
    }
}

