/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zznh;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzanw;
    private final zzn zzaqB;
    private final int zzaqC;
    private final zznh zzapE;
    private final String zzOZ;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzaa();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback, String packageName) {
        this.mVersionCode = versionCode;
        this.zzanw = dataTypes;
        this.zzaqB = zzn.zza.zzbM(bleScanCallback);
        this.zzaqC = timeoutSecs;
        this.zzapE = callback == null ? null : zznh.zza.zzbJ(callback);
        this.zzOZ = packageName;
    }

    private StartBleScanRequest(Builder builder) {
        this(zzli.zzb((Object[])builder.zzapZ), builder.zzaqB, builder.zzaqC, null, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zznh callback, String packageName) {
        this(request.zzanw, request.zzaqB, request.zzaqC, callback, packageName);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzn bleScanCallback, int timeoutSecs, zznh callback, String packageName) {
        this.mVersionCode = 3;
        this.zzanw = dataTypes;
        this.zzaqB = bleScanCallback;
        this.zzaqC = timeoutSecs;
        this.zzapE = callback;
        this.zzOZ = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzanw);
    }

    public int getTimeoutSecs() {
        return this.zzaqC;
    }

    public IBinder zzsy() {
        return this.zzaqB.asBinder();
    }

    public IBinder zzsc() {
        return this.zzapE == null ? null : this.zzapE.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("dataTypes", this.zzanw).zzg("timeoutSecs", (Object)this.zzaqC).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzaa.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzapZ = new DataType[0];
        private zzn zzaqB;
        private int zzaqC = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzapZ = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzsa().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzn zzn2) {
            this.zzaqB = zzn2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzx.zzb((stopTimeSecs > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzx.zzb((stopTimeSecs <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzaqC = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzx.zza((this.zzaqB != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

