/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> zzaVl;
    private SparseArray<zza<T>> zzaVm = new SparseArray();
    private int zzaVn = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.zzaVm.size(); ++i) {
            Tracker tracker = ((zza)this.zzaVm.valueAt(i)).zzaVa;
            tracker.onDone();
        }
        this.zzaVm.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.zzaVm.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.zzaVa = this.zzaVl.create(object);
            zza2.zzaVa.onNewItem(n, object);
            this.zzaVm.append(n, zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.zzaVm.size(); ++i) {
            int n = this.zzaVm.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.zzaVm.valueAt(i);
            zza2.zzaVp++;
            if (zza2.zzaVp != this.zzaVn) continue;
            zza2.zzaVa.onDone();
            hashSet.add(n);
        }
        for (Integer n : hashSet) {
            this.zzaVm.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            Tracker tracker = ((zza)this.zzaVm.get(n)).zzaVa;
            tracker.onUpdate(detections, object);
        }
    }

    private class zza<T> {
        private Tracker<T> zzaVa;
        private int zzaVp = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> zzaVo = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.zzaVo).zzaVl = factory;
        }

        public Builder<T> setMaxGapFrames(int maxGapFrames) {
            if (maxGapFrames < 0) {
                throw new IllegalArgumentException("Invalid max gap: " + maxGapFrames);
            }
            ((MultiProcessor)this.zzaVo).zzaVn = maxGapFrames;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.zzaVo;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

