/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzaAh;
    private final String mTag;
    private final boolean zzaAi;
    private final boolean zzaAj;
    private final int zzaAk;
    private final boolean zzaAl;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzaAh = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzaAi = builder.updateCurrent;
        this.zzaAj = builder.isPersisted;
        this.zzaAk = builder.requiredNetworkState;
        this.zzaAl = builder.requiresCharging;
        this.mExtras = builder.extras;
    }

    @Deprecated
    Task(Parcel in) {
        this.zzaAh = in.readString();
        this.mTag = in.readString();
        this.zzaAi = in.readInt() == 1;
        this.zzaAj = in.readInt() == 1;
        this.zzaAk = 2;
        this.zzaAl = false;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzaAi);
        bundle.putBoolean("persisted", this.zzaAj);
        bundle.putString("service", this.zzaAh);
        bundle.putInt("requiredNetwork", this.zzaAk);
        bundle.putBoolean("requiresCharging", this.zzaAl);
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzaAh;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzaAi;
    }

    public boolean isPersisted() {
        return this.zzaAj;
    }

    public int getRequiredNetwork() {
        return this.zzaAk;
    }

    public boolean getRequiresCharging() {
        return this.zzaAl;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.zzaAh);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzaAi ? 1 : 0);
        parcel.writeInt(this.zzaAj ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zzz(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                throw new IllegalArgumentException("Extras exceeding maximum size(10240 bytes): " + n);
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                if (Task.zzy(bundle.get(string))) continue;
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, and Boolean. ");
            }
        }
    }

    private static boolean zzy(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        protected void checkConditions() {
            zzx.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzdi(this.tag);
            if (this.isPersisted) {
                Task.zzz(this.extras);
            }
        }
    }
}

