/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import java.util.Map;

@zzgk
public class zzey
extends zzfb {
    private final Map<String, String> zzvs;
    private final Context mContext;

    public zzey(zzip zzip2, Map<String, String> map) {
        super(zzip2, "storePicture");
        this.zzvs = map;
        this.mContext = zzip2.zzgN();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzah("Activity context is not available");
            return;
        }
        zzbq zzbq2 = zzp.zzbx().zzM(this.mContext);
        if (!zzbq2.zzcX()) {
            this.zzah("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzvs.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzah("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzah("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzag(string2);
        if (!zzp.zzbx().zzay(string3)) {
            this.zzah("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzp.zzbx().zzL(this.mContext);
        builder.setTitle((CharSequence)zzp.zzbA().zzc(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzp.zzbA().zzc(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzp.zzbA().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzey.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzey.this.zzg(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzey.this.zzah("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzp.zzbA().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzey.this.zzah("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzg(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzp.zzbz().zza(request);
        return request;
    }

    String zzag(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

