/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzl zzTy = new zzl("CastRemoteDisplayLocalService");
    private static final int zzTz = R.id.cast_notification_id;
    private static final Object zzTA = new Object();
    private static AtomicBoolean zzTB = new AtomicBoolean(false);
    private GoogleApiClient zzTC;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzTD;
    private String zzSX;
    private Callbacks zzTE;
    private zzb zzTF;
    private NotificationSettings zzTG;
    private Notification mNotification;
    private Boolean zzTH;
    private PendingIntent zzTI;
    private CastDevice zzTJ;
    private Display zzTK;
    private Context zzTL;
    private ServiceConnection zzTM;
    private Handler mHandler;
    private MediaRouter zzTN;
    private final MediaRouter.Callback zzTO = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo info) {
            CastRemoteDisplayLocalService.this.zzaZ("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzTJ == null) {
                CastRemoteDisplayLocalService.this.zzaZ("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(info.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzTJ.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzaZ("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzTP;
    private final IBinder zzTQ = new zza();

    public IBinder onBind(Intent intent) {
        this.zzaZ("onBind");
        return this.zzTQ;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzaZ("onStartCommand");
        return 2;
    }

    protected static void setDebugEnabled() {
        zzTy.zzW(true);
    }

    protected Display getDisplay() {
        return this.zzTK;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzTA;
        synchronized (object) {
            return zzTP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startService(final Context activityContext, Class<? extends CastRemoteDisplayLocalService> serviceClass, final String applicationId, final CastDevice device, final NotificationSettings notificationSettings, final Callbacks callbacks) {
        zzTy.zzb("Starting Service", new Object[0]);
        Object object = zzTA;
        synchronized (object) {
            if (zzTP != null) {
                zzTy.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzQ(true);
            }
        }
        CastRemoteDisplayLocalService.zzb(activityContext, serviceClass);
        zzx.zzb((Object)activityContext, (Object)"activityContext is required.");
        zzx.zzb(serviceClass, (Object)"serviceClass is required.");
        zzx.zzb((Object)applicationId, (Object)"applicationId is required.");
        zzx.zzb((Object)device, (Object)"device is required.");
        zzx.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzx.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzTX == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzTB.getAndSet(true)) {
            zzTy.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(activityContext, serviceClass);
        activityContext.startService((Intent)object);
        activityContext.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder binder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)binder).zzlZ();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(applicationId, device, notificationSettings, activityContext, this, callbacks)) {
                    zzTy.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzTB.set(false);
                    try {
                        activityContext.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzTy.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName arg0) {
                zzTy.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzTB.set(false);
                try {
                    activityContext.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzTy.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzP(boolean bl) {
        this.zzaZ("Stopping Service");
        if (!bl && this.zzTN != null) {
            this.zzaZ("Setting default route");
            this.zzTN.selectRoute(this.zzTN.getDefaultRoute());
        }
        if (this.zzTF != null) {
            this.zzaZ("Unregistering notification receiver");
            this.unregisterReceiver(this.zzTF);
        }
        this.zzlS();
        this.zzlT();
        this.zzlO();
        if (this.zzTC != null) {
            this.zzTC.disconnect();
            this.zzTC = null;
        }
        if (this.zzTL != null && this.zzTM != null) {
            try {
                this.zzTL.unbindService(this.zzTM);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzaZ("No need to unbind service, already unbound");
            }
            this.zzTM = null;
            this.zzTL = null;
        }
        this.zzSX = null;
        this.zzTC = null;
        this.mNotification = null;
        this.zzTK = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzQ(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzTy.zzb("Stopping Service", new Object[0]);
        zzTB.set(false);
        Object object = zzTA;
        synchronized (object) {
            if (zzTP == null) {
                zzTy.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzTP;
            zzTP = null;
        }
        castRemoteDisplayLocalService.zzP(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzQ(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzx.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        if (this.zzTG == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzTH.booleanValue()) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzTX != null) {
                this.zzTG.zzTX = notificationSettings.zzTX;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzTY)) {
                this.zzTG.zzTY = notificationSettings.zzTY;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzTZ)) {
                this.zzTG.zzTZ = notificationSettings.zzTZ;
            }
            this.mNotification = this.zzR(true);
        } else {
            zzx.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzTG.mNotification = this.mNotification;
        }
        this.startForeground(zzTz, this.mNotification);
    }

    public void onCreate() {
        super.onCreate();
        this.zzTD = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzTy.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                if (CastRemoteDisplayLocalService.this.mHandler != null) {
                    CastRemoteDisplayLocalService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CastRemoteDisplayLocalService.zzQ(false);
                        }
                    });
                }
            }
        };
    }

    private static void zzb(Context context, Class clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzTK = display;
        if (this.zzTH.booleanValue()) {
            this.mNotification = this.zzR(true);
            this.startForeground(zzTz, this.mNotification);
        }
        if (this.zzTE != null) {
            this.zzTE.onRemoteDisplaySessionStarted(this);
            this.zzTE = null;
        }
        this.onCreatePresentation(this.zzTK);
    }

    private void zzlO() {
        if (this.zzTN != null) {
            zzx.zzch((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzaZ("removeMediaRouterCallback");
            this.zzTN.removeCallback(this.zzTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzaZ("startRemoteDisplaySession");
        zzx.zzch((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzTA;
        synchronized (object) {
            if (zzTP != null) {
                zzTy.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzTP = this;
        }
        this.zzTE = callbacks;
        this.zzSX = string2;
        this.zzTJ = castDevice;
        this.zzTL = context;
        this.zzTM = serviceConnection;
        this.zzTN = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzSX)).build();
        this.zzaZ("addMediaRouterCallback");
        this.zzTN.addCallback((MediaRouteSelector)object, this.zzTO, 4);
        this.mHandler = new Handler(this.getMainLooper());
        this.mNotification = notificationSettings.mNotification;
        this.zzTF = new zzb();
        this.registerReceiver(this.zzTF, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzTG = new NotificationSettings(notificationSettings);
        if (this.zzTG.mNotification == null) {
            this.zzTH = true;
            this.mNotification = this.zzR(false);
        } else {
            this.zzTH = false;
            this.mNotification = this.zzTG.mNotification;
        }
        this.startForeground(zzTz, this.mNotification);
        this.zzTC = this.zza(castDevice);
        this.zzTC.connect();
        return true;
    }

    private void zzlP() {
        this.zzaZ("startRemoteDisplay");
        if (this.zzTC == null || !this.zzTC.isConnected()) {
            zzTy.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzTC, this.zzSX).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzTy.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzlR();
                    return;
                }
                zzTy.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzTA;
                synchronized (object) {
                    if (zzTP == null) {
                        zzTy.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zzlR();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzTy.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzTB.set(false);
                if (CastRemoteDisplayLocalService.this.zzTL != null && CastRemoteDisplayLocalService.this.zzTM != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzTL.unbindService(CastRemoteDisplayLocalService.this.zzTM);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzTy.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzTM = null;
                    CastRemoteDisplayLocalService.this.zzTL = null;
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zzlQ() {
        this.zzaZ("stopRemoteDisplay");
        if (this.zzTC == null || !this.zzTC.isConnected()) {
            zzTy.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzTC).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzaZ("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzaZ("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzTK = null;
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zzlR() {
        if (this.zzTE != null) {
            this.zzTE.onRemoteDisplaySessionError(new Status(2200));
            this.zzTE = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzlS() {
        this.zzaZ("stopRemoteDisplaySession");
        this.zzlQ();
        this.onDismissPresentation();
    }

    private void zzlT() {
        this.zzaZ("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzTD);
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzaZ("onConnected");
                CastRemoteDisplayLocalService.this.zzlP();
            }

            public void onConnectionSuspended(int cause) {
                zzTy.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, cause), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                CastRemoteDisplayLocalService.this.zzbc("Connection failed: " + connectionResult);
                CastRemoteDisplayLocalService.this.zzlR();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zzlU() {
        if (this.zzTI == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            this.zzTI = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzTI;
    }

    private Notification zzR(boolean bl) {
        int n;
        int n2;
        this.zzaZ("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzTG.zzTY;
        String string3 = this.zzTG.zzTZ;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzTJ.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzTG.zzTX).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzlU()).build();
        return notification;
    }

    private void zzaZ(String string2) {
        zzTy.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbc(String string2) {
        zzTy.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzlZ() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzTy.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzTX;
        private String zzTY;
        private String zzTZ;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings newSettings) {
            this.mNotification = newSettings.mNotification;
            this.zzTX = newSettings.zzTX;
            this.zzTY = newSettings.zzTY;
            this.zzTZ = newSettings.zzTZ;
        }

        public static final class Builder {
            private NotificationSettings zzUa = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzUa.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent notificationPendingIntent) {
                this.zzUa.zzTX = notificationPendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String notificationTitle) {
                this.zzUa.zzTY = notificationTitle;
                return this;
            }

            public Builder setNotificationText(String notificationText) {
                this.zzUa.zzTZ = notificationText;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzUa.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzUa.zzTY)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzUa.zzTZ)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzUa.zzTX != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzUa.zzTY) && TextUtils.isEmpty((CharSequence)this.zzUa.zzTZ) && this.zzUa.zzTX == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzUa;
            }
        }
    }

    public static interface Callbacks {
        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

