/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzln;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaxY;
    private final PlayerEntity zzazn;
    private final String zzasZ;
    private final Uri zzazk;
    private final String zzazo;
    private final String zzagU;
    private final String zzaoB;
    private final long zzazp;
    private final long zzazq;
    private final float zzazr;
    private final String zzazs;
    private final boolean zzazt;
    private final long zzazu;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 5;
        this.zzaxY = new GameEntity(snapshotMetadata.getGame());
        this.zzazn = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzasZ = snapshotMetadata.getSnapshotId();
        this.zzazk = snapshotMetadata.getCoverImageUri();
        this.zzazo = snapshotMetadata.getCoverImageUrl();
        this.zzazr = snapshotMetadata.getCoverImageAspectRatio();
        this.zzagU = snapshotMetadata.getTitle();
        this.zzaoB = snapshotMetadata.getDescription();
        this.zzazp = snapshotMetadata.getLastModifiedTimestamp();
        this.zzazq = snapshotMetadata.getPlayedTime();
        this.zzazs = snapshotMetadata.getUniqueName();
        this.zzazt = snapshotMetadata.hasChangePending();
        this.zzazu = snapshotMetadata.getProgressValue();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue) {
        this.mVersionCode = versionCode;
        this.zzaxY = game;
        this.zzazn = owner;
        this.zzasZ = snapshotId;
        this.zzazk = coverImageUri;
        this.zzazo = coverImageUrl;
        this.zzazr = coverImageAspectRatio;
        this.zzagU = title;
        this.zzaoB = description;
        this.zzazp = lastModifiedTimestamp;
        this.zzazq = playedTime;
        this.zzazs = uniqueName;
        this.zzazt = changePending;
        this.zzazu = progressValue;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaxY;
    }

    @Override
    public Player getOwner() {
        return this.zzazn;
    }

    @Override
    public String getSnapshotId() {
        return this.zzasZ;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzazk;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzazo;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzazr;
    }

    @Override
    public String getUniqueName() {
        return this.zzazs;
    }

    @Override
    public String getTitle() {
        return this.zzagU;
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzazp;
    }

    @Override
    public long getPlayedTime() {
        return this.zzazq;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzazt;
    }

    @Override
    public long getProgressValue() {
        return this.zzazu;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzw.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzw.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzw.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzw.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzw.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzw.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzw.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzw.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzw.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzw.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzw.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzw.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzw.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzw.zzu((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

