/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.zzln;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaxY;
    private final String zzatz;
    private final String zzayv;
    private final long zzaxZ;
    private final String zzayD;
    private final long zzasc;
    private final String zzayE;
    private final int zzayF;
    private final int zzayd;
    private final int mVersion;
    private final byte[] zzayG;
    private final ArrayList<ParticipantEntity> zzayc;
    private final String zzayH;
    private final byte[] zzayI;
    private final int zzayJ;
    private final Bundle zzayt;
    private final int zzayK;
    private final boolean zzayL;
    private final String zzaoB;
    private final String zzayM;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.mVersionCode = 2;
        this.zzaxY = new GameEntity(match.getGame());
        this.zzatz = match.getMatchId();
        this.zzayv = match.getCreatorId();
        this.zzaxZ = match.getCreationTimestamp();
        this.zzayD = match.getLastUpdaterId();
        this.zzasc = match.getLastUpdatedTimestamp();
        this.zzayE = match.getPendingParticipantId();
        this.zzayF = match.getStatus();
        this.zzayK = match.getTurnStatus();
        this.zzayd = match.getVariant();
        this.mVersion = match.getVersion();
        this.zzayH = match.getRematchId();
        this.zzayJ = match.getMatchNumber();
        this.zzayt = match.getAutoMatchCriteria();
        this.zzayL = match.isLocallyModified();
        this.zzaoB = match.getDescription();
        this.zzayM = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.zzayG = null;
        } else {
            this.zzayG = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzayG, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzayI = null;
        } else {
            this.zzayI = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzayI, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n = arrayList.size();
        this.zzayc = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzayc.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.mVersionCode = versionCode;
        this.zzaxY = game;
        this.zzatz = matchId;
        this.zzayv = creatorId;
        this.zzaxZ = creationTimestamp;
        this.zzayD = lastUpdaterId;
        this.zzasc = lastUpdatedTimestamp;
        this.zzayE = pendingParticipantId;
        this.zzayF = matchStatus;
        this.zzayK = turnStatus;
        this.zzayd = variant;
        this.mVersion = version;
        this.zzayG = data;
        this.zzayc = participants;
        this.zzayH = rematchId;
        this.zzayI = previousData;
        this.zzayJ = matchNumber;
        this.zzayt = autoMatchCriteria;
        this.zzayL = isLocallyModified;
        this.zzaoB = description;
        this.zzayM = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaxY;
    }

    @Override
    public String getMatchId() {
        return this.zzatz;
    }

    @Override
    public String getCreatorId() {
        return this.zzayv;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaxZ;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzayD;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzasc;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzayE;
    }

    @Override
    public int getStatus() {
        return this.zzayF;
    }

    @Override
    public int getTurnStatus() {
        return this.zzayK;
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzayM;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzayd;
    }

    @Override
    public byte[] getData() {
        return this.zzayG;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.zzayH;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzayI;
    }

    @Override
    public int getMatchNumber() {
        return this.zzayJ;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzayt;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzayt == null) {
            return 0;
        }
        return this.zzayt.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzayF == 2 && this.zzayH == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzayL;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.zzc(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzayc);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzw.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, obj);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzw.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzw.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzw.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzw.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzw.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzw.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzw.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzw.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzw.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzw.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzw.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzw.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzw.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzw.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzw.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzw.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzw.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzw.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzw.zzu((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.zza(this, out, flags);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

