/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzamN;
    private Bundle zzamO;
    private LinkedList<zza> zzamP;
    private final zzf<T> zzamQ = new zzf<T>(){

        @Override
        public void zza(T t) {
            zza.this.zzamN = t;
            for (zza zza2 : zza.this.zzamP) {
                zza2.zzb(zza.this.zzamN);
            }
            zza.this.zzamP.clear();
            zza.this.zzamO = null;
        }
    };

    public T zzrn() {
        return this.zzamN;
    }

    private void zzei(int n) {
        while (!this.zzamP.isEmpty() && this.zzamP.getLast().getState() >= n) {
            this.zzamP.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzamN != null) {
            zza2.zzb((LifecycleDelegate)this.zzamN);
            return;
        }
        if (this.zzamP == null) {
            this.zzamP = new LinkedList();
        }
        this.zzamP.add(zza2);
        if (bundle != null) {
            if (this.zzamO == null) {
                this.zzamO = (Bundle)bundle.clone();
            } else {
                this.zzamO.putAll(bundle);
            }
        }
        this.zza(this.zzamQ);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle attrs, final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzamN.onInflate(activity, attrs, savedInstanceState);
            }
        });
    }

    public void onCreate(final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzamN.onCreate(savedInstanceState);
            }
        });
    }

    public View onCreateView(final LayoutInflater inflater, final ViewGroup container, final Bundle savedInstanceState) {
        final FrameLayout frameLayout = new FrameLayout(inflater.getContext());
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzamN.onCreateView(inflater, container, savedInstanceState));
            }
        });
        if (this.zzamN == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzg.zzb(context, n, GooglePlayServicesUtil.zzaf(context));
        String string3 = zzg.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    context.startActivity(GooglePlayServicesUtil.zzbc(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzamN.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzamN.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzamN != null) {
            this.zzamN.onPause();
        } else {
            this.zzei(5);
        }
    }

    public void onStop() {
        if (this.zzamN != null) {
            this.zzamN.onStop();
        } else {
            this.zzei(4);
        }
    }

    public void onDestroyView() {
        if (this.zzamN != null) {
            this.zzamN.onDestroyView();
        } else {
            this.zzei(2);
        }
    }

    public void onDestroy() {
        if (this.zzamN != null) {
            this.zzamN.onDestroy();
        } else {
            this.zzei(1);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.zzamN != null) {
            this.zzamN.onSaveInstanceState(outState);
        } else if (this.zzamO != null) {
            outState.putAll(this.zzamO);
        }
    }

    public void onLowMemory() {
        if (this.zzamN != null) {
            this.zzamN.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

