/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzk
implements Handler.Callback {
    private final zza zzadM;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzadN = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzadO = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzadP = new ArrayList();
    private volatile boolean zzadQ = false;
    private final AtomicInteger zzadR = new AtomicInteger(0);
    private boolean zzadS = false;
    private final Handler mHandler;
    private final Object zzpc = new Object();

    public zzk(Looper looper, zza zza2) {
        this.zzadM = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzoI() {
        this.zzadQ = false;
        this.zzadR.incrementAndGet();
    }

    public void zzoJ() {
        this.zzadQ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzh(Bundle bundle) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzpc;
        synchronized (object) {
            zzx.zzY(!this.zzadS);
            this.mHandler.removeMessages(1);
            this.zzadS = true;
            zzx.zzY(this.zzadO.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzadN);
            int n = this.zzadR.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzadQ || !this.zzadM.isConnected() || this.zzadR.get() != n) break;
                if (this.zzadO.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzadO.clear();
            this.zzadS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbB(int n) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpc;
        synchronized (object) {
            this.zzadS = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzadN);
            int n2 = this.zzadR.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzadQ || this.zzadR.get() != n2) break;
                if (!this.zzadN.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzadO.clear();
            this.zzadS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzj(ConnectionResult connectionResult) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpc;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzadP);
            int n = this.zzadR.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzadQ || this.zzadR.get() != n) {
                    return;
                }
                if (!this.zzadP.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzv(listener);
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzadN.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzadN.add(listener);
            }
        }
        if (this.zzadM.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzv(listener);
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzadN.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzv(listener);
        Object object = this.zzpc;
        synchronized (object) {
            boolean bl = this.zzadN.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzadS) {
                this.zzadO.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzv(listener);
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzadP.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzadP.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzv(listener);
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzadP.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzv(listener);
        Object object = this.zzpc;
        synchronized (object) {
            boolean bl = this.zzadP.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            Object object = this.zzpc;
            synchronized (object) {
                if (this.zzadQ && this.zzadM.isConnected() && this.zzadN.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzadM.zzmw();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)"Don't know how to handle this message.");
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzmw();
    }
}

