/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableOptions;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzad;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzt
extends zzj<zzal> {
    private final String zzQl;
    private final Bundle zzaip;
    private final boolean zzaiq;
    private DriveId zzair;
    private DriveId zzais;
    final GoogleApiClient.ConnectionCallbacks zzadB;
    final Map<DriveId, Map<ChangeListener, zzad>> zzait = new HashMap<DriveId, Map<ChangeListener, zzad>>();
    final Map<zzc, zzad> zzaiu = new HashMap<zzc, zzad>();
    final Map<DriveId, Map<zzi, zzad>> zzaiv = new HashMap<DriveId, Map<zzi, zzad>>();
    final Map<DriveId, Map<zzi, zzad>> zzaiw = new HashMap<DriveId, Map<zzi, zzad>>();

    public zzt(Context context, Looper looper, zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzQl = zzf2.zzol();
        this.zzadB = connectionCallbacks;
        this.zzaip = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaiq = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.zzaiq = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    public boolean zzlm() {
        return !this.getContext().getPackageName().equals(this.zzQl) || !this.zzqE();
    }

    public boolean zzoC() {
        return true;
    }

    boolean zzqE() {
        return GooglePlayServicesUtil.zze((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzal zzaR(IBinder iBinder) {
        return zzal.zza.zzaS(iBinder);
    }

    protected String zzfB() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzli() {
        String string = this.getContext().getPackageName();
        zzx.zzv((Object)string);
        zzx.zzY((!this.zzoy().zzoj().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzQl)) {
            bundle.putString("proxy_package_name", this.zzQl);
        }
        bundle.putAll(this.zzaip);
        return bundle;
    }

    protected String zzfA() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzal zzqF() throws DeadObjectException {
        return (zzal)this.zzoA();
    }

    public DriveId zzqG() {
        return this.zzair;
    }

    public DriveId zzqH() {
        return this.zzais;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzal)this.zzoA();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzait;
        synchronized (map) {
            this.zzait.clear();
        }
        map = this.zzaiu;
        synchronized (map) {
            this.zzaiu.clear();
        }
        map = this.zzaiv;
        synchronized (map) {
            this.zzaiv.clear();
        }
        map = this.zzaiw;
        synchronized (map) {
            this.zzaiw.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzair = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzais = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzqI() {
        return this.zzaiq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zzb((Object)changeListener, (Object)"listener");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzad>> map = this.zzait;
        synchronized (map) {
            zzad zzad2;
            Map<ChangeListener, zzad> map2 = this.zzait.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzad>();
                this.zzait.put(driveId, map2);
            }
            if ((zzad2 = map2.get(changeListener)) == null) {
                zzad2 = new zzad(this.getLooper(), this.getContext(), n, changeListener);
                map2.put(changeListener, zzad2);
            } else if (zzad2.zzcK(n)) {
                return new zzr.zzj(googleApiClient, Status.zzaaD);
            }
            zzad2.zzcJ(n);
            return this.zza(googleApiClient, n, driveId, zzad2, null);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzad zzad2, final ChangesAvailableOptions changesAvailableOptions) {
        return googleApiClient.zzb((zzc.zza)new zzs.zza(googleApiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), (zzan)zzad2, null, (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzx.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzad>> map = this.zzait;
        synchronized (map) {
            Map<ChangeListener, zzad> map2 = this.zzait.get(driveId);
            if (map2 == null) {
                return new zzr.zzj(googleApiClient, Status.zzaaD);
            }
            zzad zzad2 = map2.remove(changeListener);
            if (zzad2 == null) {
                return new zzr.zzj(googleApiClient, Status.zzaaD);
            }
            if (map2.isEmpty()) {
                this.zzait.remove(driveId);
            }
            return this.zza(googleApiClient, n, driveId, zzad2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzad zzad2) {
        return googleApiClient.zzb((zzc.zza)new zzs.zza(googleApiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new RemoveEventListenerRequest(driveId, n), (zzan)zzad2, null, (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId, (ChangesAvailableOptions)null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final ChangesAvailableOptions changesAvailableOptions) {
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaiq) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zzc.zza)new zzs.zza(googleApiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), null, null, (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zzc.zza)new zzs.zza(googleApiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        zzx.zzZ((pendingTags != null ? 1 : 0) != 0);
        zzx.zzZ((!pendingTags.isEmpty() ? 1 : 0) != 0);
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new CancelPendingActionsRequest(pendingTags), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzaR(iBinder);
    }
}

