/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmd;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzagR = new MetadataChangeSet(MetadataBundle.zzrb());
    private final MetadataBundle zzagS;

    public MetadataChangeSet(MetadataBundle bag) {
        this.zzagS = MetadataBundle.zza(bag);
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzagS.zza(zzmb.zzakq);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzqX();
    }

    public String getDescription() {
        return this.zzagS.zza(zzmb.zzakr);
    }

    public String getIndexableText() {
        return this.zzagS.zza(zzmb.zzakx);
    }

    public Date getLastViewedByMeDate() {
        return this.zzagS.zza(zzmd.zzale);
    }

    public String getMimeType() {
        return this.zzagS.zza(zzmb.zzakL);
    }

    public String getTitle() {
        return this.zzagS.zza(zzmb.zzakU);
    }

    public Boolean isPinned() {
        return this.zzagS.zza(zzmb.zzakD);
    }

    public Boolean isStarred() {
        return this.zzagS.zza(zzmb.zzakS);
    }

    public Boolean isViewed() {
        return this.zzagS.zza(zzmb.zzakK);
    }

    public MetadataBundle zzqp() {
        return this.zzagS;
    }

    public static class Builder {
        private final MetadataBundle zzagS = MetadataBundle.zzrb();
        private AppVisibleCustomProperties.zza zzagT;

        private AppVisibleCustomProperties.zza zzqq() {
            if (this.zzagT == null) {
                this.zzagT = new AppVisibleCustomProperties.zza();
            }
            return this.zzagT;
        }

        private int zzcE(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzx.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey key, String value) {
            zzx.zzb((Object)key, (Object)"key");
            zzx.zzb((Object)value, (Object)"value");
            int n = this.zzcE(key.getKey()) + this.zzcE(value);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzqq().zza(key, value);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey key) {
            zzx.zzb((Object)key, (Object)"key");
            this.zzqq().zza(key, null);
            return this;
        }

        public Builder setDescription(String description) {
            this.zzagS.zzb(zzmb.zzakr, description);
            return this;
        }

        public Builder setIndexableText(String text) {
            int n = this.zzcE(text);
            this.zzk("Indexable text size", 131072, n);
            this.zzagS.zzb(zzmb.zzakx, text);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzagS.zzb(zzmd.zzale, date);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.zzagS.zzb(zzmb.zzakL, mimeType);
            return this;
        }

        public Builder setPinned(boolean pinned) {
            this.zzagS.zzb(zzmb.zzakD, pinned);
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.zzagS.zzb(zzmb.zzakS, starred);
            return this;
        }

        public Builder setTitle(String title) {
            this.zzagS.zzb(zzmb.zzakU, title);
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.zzagS.zzb(zzmb.zzakK, viewed);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzagT != null) {
                this.zzagS.zzb(zzmb.zzakq, this.zzagT.zzqY());
            }
            return new MetadataChangeSet(this.zzagS);
        }
    }
}

