/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.zzk;
import com.google.android.gms.drive.internal.zzu;

public class CreateFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private final zzk zzagu = new zzk(0);
    private DriveContents zzagv;
    private boolean zzagw;

    public CreateFileActivityBuilder setInitialDriveContents(DriveContents driveContents) {
        if (driveContents != null) {
            if (!(driveContents instanceof zzu)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzqj()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            this.zzagu.zzcC(driveContents.zzqh().getRequestId());
            this.zzagv = driveContents;
        } else {
            this.zzagu.zzcC(1);
        }
        this.zzagw = true;
        return this;
    }

    public CreateFileActivityBuilder setInitialMetadata(MetadataChangeSet metadataChangeSet) {
        this.zzagu.zza(metadataChangeSet);
        return this;
    }

    public CreateFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzagu.zza(folder);
        return this;
    }

    public CreateFileActivityBuilder setActivityTitle(String title) {
        this.zzagu.zzcF(title);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zzb((Object)this.zzagw, (Object)"Must call setInitialDriveContents to CreateFileActivityBuilder.");
        zzx.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        zzx.zzb((apiClient.zza(Drive.SCOPE_FILE) || apiClient.zza(Drive.zzagx) ? 1 : 0) != 0, (Object)"The apiClient must have suitable scope to create files");
        if (this.zzagv != null) {
            this.zzagv.zzqi();
        }
        return this.zzagu.build(apiClient);
    }
}

