/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzm
extends zzl
implements Handler.Callback {
    private final HashMap<zza, zzb> zzadV = new HashMap();
    private final Context zzqO;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzadW;
    private final long zzadX;

    zzm(Context context) {
        this.zzqO = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzadW = com.google.android.gms.common.stats.zzb.zzpD();
        this.zzadX = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzadV;
        synchronized (hashMap) {
            zzb zzb2 = this.zzadV.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzcl(string2);
                this.zzadV.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzcl(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzadV;
        synchronized (hashMap) {
            zzb zzb2 = this.zzadV.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                throw new IllegalStateException("Trying to unbind a GmsServiceConnection  that was not bound before.  config=" + zza2);
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzoL()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzadX);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzadV;
                synchronized (hashMap) {
                    if (zzb2.zzoL()) {
                        if (zzb2.isBound()) {
                            zzb2.zzcm("GmsClientSupervisor");
                        }
                        this.zzadV.remove(zzb2.zzaec);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzOj;
        private final ComponentName zzadY;

        public zza(String string2) {
            this.zzOj = zzx.zzcs(string2);
            this.zzadY = null;
        }

        public zza(ComponentName componentName) {
            this.zzOj = null;
            this.zzadY = zzx.zzv(componentName);
        }

        public String toString() {
            return this.zzOj == null ? this.zzadY.flattenToString() : this.zzOj;
        }

        public Intent zzoK() {
            Intent intent = this.zzOj != null ? new Intent(this.zzOj).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzadY);
            return intent;
        }

        public int hashCode() {
            return zzw.hashCode(this.zzOj, this.zzadY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzw.equal(this.zzOj, zza2.zzOj) && zzw.equal(this.zzadY, zza2.zzadY);
        }
    }

    private final class zzb {
        private final zza zzadZ;
        private final Set<ServiceConnection> zzaea;
        private int mState;
        private boolean zzaeb;
        private IBinder zzacE;
        private final com.google.android.gms.common.internal.zzm$zza zzaec;
        private ComponentName zzadY;

        public zzb(com.google.android.gms.common.internal.zzm$zza zza2) {
            this.zzaec = zza2;
            this.zzadZ = new zza();
            this.zzaea = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        public void zzcl(String string2) {
            this.zzaeb = zzm.this.zzadW.zza(zzm.this.zzqO, string2, this.zzaec.zzoK(), this.zzadZ, 129);
            if (this.zzaeb) {
                this.mState = 3;
            } else {
                try {
                    zzm.this.zzadW.zza(zzm.this.zzqO, this.zzadZ);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzcm(String string2) {
            zzm.this.zzadW.zza(zzm.this.zzqO, this.zzadZ);
            this.zzaeb = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzadW.zza(zzm.this.zzqO, serviceConnection, string2, this.zzaec.zzoK());
            this.zzaea.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzadW.zzb(zzm.this.zzqO, serviceConnection);
            this.zzaea.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzaeb;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzaea.contains(serviceConnection);
        }

        public boolean zzoL() {
            return this.zzaea.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzacE;
        }

        public ComponentName getComponentName() {
            return this.zzadY;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzm.this.zzadV;
                synchronized (hashMap) {
                    zzb.this.zzacE = binder;
                    zzb.this.zzadY = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzaea) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzm.this.zzadV;
                synchronized (hashMap) {
                    zzb.this.zzacE = null;
                    zzb.this.zzadY = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzaea) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

