/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.RemoteControlClient;
import android.os.Bundle;
import android.os.ResultReceiver;

class MediaSessionCompatApi14 {
    static final int RCC_PLAYSTATE_NONE = 0;
    static final int STATE_NONE = 0;
    static final int STATE_STOPPED = 1;
    static final int STATE_PAUSED = 2;
    static final int STATE_PLAYING = 3;
    static final int STATE_FAST_FORWARDING = 4;
    static final int STATE_REWINDING = 5;
    static final int STATE_BUFFERING = 6;
    static final int STATE_ERROR = 7;
    static final int STATE_CONNECTING = 8;
    static final int STATE_SKIPPING_TO_PREVIOUS = 9;
    static final int STATE_SKIPPING_TO_NEXT = 10;
    static final int STATE_SKIPPING_TO_QUEUE_ITEM = 11;
    private static final long ACTION_STOP = 1L;
    private static final long ACTION_PAUSE = 2L;
    private static final long ACTION_PLAY = 4L;
    private static final long ACTION_REWIND = 8L;
    private static final long ACTION_SKIP_TO_PREVIOUS = 16L;
    private static final long ACTION_SKIP_TO_NEXT = 32L;
    private static final long ACTION_FAST_FORWARD = 64L;
    private static final long ACTION_PLAY_PAUSE = 512L;
    private static final String METADATA_KEY_ART = "android.media.metadata.ART";
    private static final String METADATA_KEY_ALBUM_ART = "android.media.metadata.ALBUM_ART";
    private static final String METADATA_KEY_TITLE = "android.media.metadata.TITLE";
    private static final String METADATA_KEY_ARTIST = "android.media.metadata.ARTIST";
    private static final String METADATA_KEY_DURATION = "android.media.metadata.DURATION";
    private static final String METADATA_KEY_ALBUM = "android.media.metadata.ALBUM";
    private static final String METADATA_KEY_AUTHOR = "android.media.metadata.AUTHOR";
    private static final String METADATA_KEY_WRITER = "android.media.metadata.WRITER";
    private static final String METADATA_KEY_COMPOSER = "android.media.metadata.COMPOSER";
    private static final String METADATA_KEY_COMPILATION = "android.media.metadata.COMPILATION";
    private static final String METADATA_KEY_DATE = "android.media.metadata.DATE";
    private static final String METADATA_KEY_GENRE = "android.media.metadata.GENRE";
    private static final String METADATA_KEY_TRACK_NUMBER = "android.media.metadata.TRACK_NUMBER";
    private static final String METADATA_KEY_DISC_NUMBER = "android.media.metadata.DISC_NUMBER";
    private static final String METADATA_KEY_ALBUM_ARTIST = "android.media.metadata.ALBUM_ARTIST";

    MediaSessionCompatApi14() {
    }

    public static Object createRemoteControlClient(PendingIntent mbIntent) {
        return new RemoteControlClient(mbIntent);
    }

    public static void setState(Object rccObj, int state) {
        ((RemoteControlClient)rccObj).setPlaybackState(MediaSessionCompatApi14.getRccStateFromState(state));
    }

    public static void setTransportControlFlags(Object rccObj, long actions) {
        ((RemoteControlClient)rccObj).setTransportControlFlags(MediaSessionCompatApi14.getRccTransportControlFlagsFromActions(actions));
    }

    public static void setMetadata(Object rccObj, Bundle metadata) {
        RemoteControlClient.MetadataEditor editor = ((RemoteControlClient)rccObj).editMetadata(true);
        MediaSessionCompatApi14.buildOldMetadata(metadata, editor);
        editor.apply();
    }

    public static void registerRemoteControlClient(Context context, Object rccObj) {
        AudioManager am = (AudioManager)context.getSystemService("audio");
        am.registerRemoteControlClient((RemoteControlClient)rccObj);
    }

    public static void unregisterRemoteControlClient(Context context, Object rccObj) {
        AudioManager am = (AudioManager)context.getSystemService("audio");
        am.unregisterRemoteControlClient((RemoteControlClient)rccObj);
    }

    static int getRccStateFromState(int state) {
        switch (state) {
            case 6: 
            case 8: {
                return 8;
            }
            case 7: {
                return 9;
            }
            case 4: {
                return 4;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 9: {
                return 7;
            }
            case 10: 
            case 11: {
                return 6;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    static int getRccTransportControlFlagsFromActions(long actions) {
        int transportControlFlags = 0;
        if ((actions & 1L) != 0L) {
            transportControlFlags |= 0x20;
        }
        if ((actions & 2L) != 0L) {
            transportControlFlags |= 0x10;
        }
        if ((actions & 4L) != 0L) {
            transportControlFlags |= 4;
        }
        if ((actions & 8L) != 0L) {
            transportControlFlags |= 2;
        }
        if ((actions & 0x10L) != 0L) {
            transportControlFlags |= 1;
        }
        if ((actions & 0x20L) != 0L) {
            transportControlFlags |= 0x80;
        }
        if ((actions & 0x40L) != 0L) {
            transportControlFlags |= 0x40;
        }
        if ((actions & 0x200L) != 0L) {
            transportControlFlags |= 8;
        }
        return transportControlFlags;
    }

    static void buildOldMetadata(Bundle metadata, RemoteControlClient.MetadataEditor editor) {
        if (metadata == null) {
            return;
        }
        if (metadata.containsKey(METADATA_KEY_ART)) {
            Bitmap art = (Bitmap)metadata.getParcelable(METADATA_KEY_ART);
            editor.putBitmap(100, art);
        } else if (metadata.containsKey(METADATA_KEY_ALBUM_ART)) {
            Bitmap art = (Bitmap)metadata.getParcelable(METADATA_KEY_ALBUM_ART);
            editor.putBitmap(100, art);
        }
        if (metadata.containsKey(METADATA_KEY_ALBUM)) {
            editor.putString(1, metadata.getString(METADATA_KEY_ALBUM));
        }
        if (metadata.containsKey(METADATA_KEY_ALBUM_ARTIST)) {
            editor.putString(13, metadata.getString(METADATA_KEY_ALBUM_ARTIST));
        }
        if (metadata.containsKey(METADATA_KEY_ARTIST)) {
            editor.putString(2, metadata.getString(METADATA_KEY_ARTIST));
        }
        if (metadata.containsKey(METADATA_KEY_AUTHOR)) {
            editor.putString(3, metadata.getString(METADATA_KEY_AUTHOR));
        }
        if (metadata.containsKey(METADATA_KEY_COMPILATION)) {
            editor.putString(15, metadata.getString(METADATA_KEY_COMPILATION));
        }
        if (metadata.containsKey(METADATA_KEY_COMPOSER)) {
            editor.putString(4, metadata.getString(METADATA_KEY_COMPOSER));
        }
        if (metadata.containsKey(METADATA_KEY_DATE)) {
            editor.putString(5, metadata.getString(METADATA_KEY_DATE));
        }
        if (metadata.containsKey(METADATA_KEY_DISC_NUMBER)) {
            editor.putLong(14, metadata.getLong(METADATA_KEY_DISC_NUMBER));
        }
        if (metadata.containsKey(METADATA_KEY_DURATION)) {
            editor.putLong(9, metadata.getLong(METADATA_KEY_DURATION));
        }
        if (metadata.containsKey(METADATA_KEY_GENRE)) {
            editor.putString(6, metadata.getString(METADATA_KEY_GENRE));
        }
        if (metadata.containsKey(METADATA_KEY_TITLE)) {
            editor.putString(7, metadata.getString(METADATA_KEY_TITLE));
        }
        if (metadata.containsKey(METADATA_KEY_TRACK_NUMBER)) {
            editor.putLong(0, metadata.getLong(METADATA_KEY_TRACK_NUMBER));
        }
        if (metadata.containsKey(METADATA_KEY_WRITER)) {
            editor.putString(11, metadata.getString(METADATA_KEY_WRITER));
        }
    }

    static interface Callback {
        public void onCommand(String var1, Bundle var2, ResultReceiver var3);

        public boolean onMediaButtonEvent(Intent var1);

        public void onPlay();

        public void onPause();

        public void onSkipToNext();

        public void onSkipToPrevious();

        public void onFastForward();

        public void onRewind();

        public void onStop();

        public void onSeekTo(long var1);

        public void onSetRating(Object var1);
    }
}

