/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int mVersionCode;
    private final DataSource zzanm;
    private final zzj zzaqi;
    private final long zzaqR;
    private final long zzaqS;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.mVersionCode = versionCode;
        this.zzanm = dataSource;
        this.zzaqi = zzj.zza.zzbl(listenerBinder);
        this.zzaqR = samplingRateMicros;
        this.zzaqS = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.zzanm;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzaqi);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzaqR == -1L ? -1L : timeUnit.convert(this.zzaqR, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaqS, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.zzanm);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzst() {
        return this.zzaqi.asBinder();
    }

    public long zzrP() {
        return this.zzaqR;
    }

    public long zzsJ() {
        return this.zzaqS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zza.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)that);
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzw.equal((Object)this.zzanm, (Object)fitnessSensorServiceRequest.zzanm) && this.zzaqR == fitnessSensorServiceRequest.zzaqR && this.zzaqS == fitnessSensorServiceRequest.zzaqS;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanm, this.zzaqR, this.zzaqS});
    }
}

