/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzu;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zznh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final Session zzanp;
    private final List<DataSet> zzany;
    private final List<DataPoint> zzaqt;
    private final zznh zzapE;
    private final String zzOZ;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzu();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback, String packageName) {
        this.mVersionCode = versionCode;
        this.zzanp = session;
        this.zzany = Collections.unmodifiableList(dataSets);
        this.zzaqt = Collections.unmodifiableList(aggregateDataPoints);
        this.zzapE = callback == null ? null : zznh.zza.zzbJ(callback);
        this.zzOZ = packageName;
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzanp, builder.zzany, builder.zzaqt, null, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zznh callback, String packageName) {
        this(request.zzanp, request.zzany, request.zzaqt, callback, packageName);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zznh callback, String packageName) {
        this.mVersionCode = 2;
        this.zzanp = session;
        this.zzany = Collections.unmodifiableList(dataSets);
        this.zzaqt = Collections.unmodifiableList(aggregateDataPoints);
        this.zzapE = callback;
        this.zzOZ = packageName;
    }

    public Session getSession() {
        return this.zzanp;
    }

    public List<DataSet> getDataSets() {
        return this.zzany;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzaqt;
    }

    public IBinder zzsc() {
        return this.zzapE == null ? null : this.zzapE.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzw.equal((Object)this.zzanp, (Object)sessionInsertRequest.zzanp) && zzw.equal(this.zzany, sessionInsertRequest.zzany) && zzw.equal(this.zzaqt, sessionInsertRequest.zzaqt);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanp, this.zzany, this.zzaqt});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("session", (Object)this.zzanp).zzg("dataSets", this.zzany).zzg("aggregateDataPoints", this.zzaqt).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzu.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzanp;
        private List<DataSet> zzany = new ArrayList<DataSet>();
        private List<DataPoint> zzaqt = new ArrayList<DataPoint>();
        private List<DataSource> zzaqu = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzanp = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzx.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzx.zza((!this.zzaqu.contains(dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzx.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzaqu.add(dataSource);
            this.zzany.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            zzx.zzb((aggregateDataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            long l = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            zzx.zzb((l > 0L && l2 > l ? 1 : 0) != 0, (String)"Aggregate data point should have valid start and end times: %s", (Object[])new Object[]{aggregateDataPoint});
            DataSource dataSource = aggregateDataPoint.getDataSource();
            zzx.zza((!this.zzaqu.contains(dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            this.zzaqu.add(dataSource);
            this.zzaqt.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzx.zza((this.zzanp != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzx.zza((this.zzanp.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzsv();
            return new SessionInsertRequest(this);
        }

        private void zzd(DataPoint dataPoint) {
            this.zzf(dataPoint);
            this.zze(dataPoint);
        }

        private void zze(DataPoint dataPoint) {
            long l = this.zzanp.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzanp.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzmh.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzf(DataPoint dataPoint) {
            long l = this.zzanp.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzanp.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzmh.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzsv() {
            for (DataSet object : this.zzany) {
                for (DataPoint dataPoint : object.getDataPoints()) {
                    this.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzaqt) {
                this.zzd(dataPoint);
            }
        }
    }
}

