/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int mVersionCode;
    private final DataType zzanl;
    private final String mName;
    private final int zzUS;
    private final Device zzanJ;
    private final Application zzanK;
    private final String zzanL;
    private final String zzanM;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, Application application, String streamName) {
        this.mVersionCode = versionCode;
        this.zzanl = dataType;
        this.zzUS = type;
        this.mName = name;
        this.zzanJ = device;
        this.zzanK = application;
        this.zzanL = streamName;
        this.zzanM = this.zzrG();
    }

    private DataSource(Builder builder) {
        this.mVersionCode = 3;
        this.zzanl = builder.zzanl;
        this.zzUS = builder.zzUS;
        this.mName = builder.mName;
        this.zzanJ = builder.zzanJ;
        this.zzanK = builder.zzanK;
        this.zzanL = builder.zzanL;
        this.zzanM = this.zzrG();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzanl;
    }

    public int getType() {
        return this.zzUS;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzanK == null ? null : this.zzanK.getPackageName();
    }

    public Application zzrF() {
        return this.zzanK;
    }

    public Device getDevice() {
        return this.zzanJ;
    }

    public String getStreamName() {
        return this.zzanL;
    }

    public String getStreamIdentifier() {
        return this.zzanM;
    }

    private String zzrG() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzanl.getName());
        if (this.zzanK != null) {
            stringBuilder.append(":").append(this.zzanK.getPackageName());
        }
        if (this.zzanJ != null) {
            stringBuilder.append(":").append(this.zzanJ.getStreamIdentifier());
        }
        if (this.zzanL != null) {
            stringBuilder.append(":").append(this.zzanL);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzanM.equals(dataSource.zzanM);
    }

    public int hashCode() {
        return this.zzanM.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzanK != null) {
            stringBuilder.append(":").append(this.zzanK);
        }
        if (this.zzanJ != null) {
            stringBuilder.append(":").append(this.zzanJ);
        }
        if (this.zzanL != null) {
            stringBuilder.append(":").append(this.zzanL);
        }
        stringBuilder.append(":").append(this.zzanl);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzUS == 0 ? "r" : "d") + ":" + this.zzanl.zzrH() + (this.zzanK == null ? "" : (this.zzanK.equals(Application.zzans) ? ":gms" : ":" + this.zzanK.getPackageName())) + (this.zzanJ != null ? ":" + this.zzanJ.getModel() + ":" + this.zzanJ.getUid() : "") + (this.zzanL != null ? ":" + this.zzanL : "");
    }

    private String getTypeString() {
        switch (this.zzUS) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }

    public static final class Builder {
        private DataType zzanl;
        private int zzUS = -1;
        private String mName;
        private Device zzanJ;
        private Application zzanK;
        private String zzanL = "";

        public Builder setDataType(DataType dataType) {
            this.zzanl = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzUS = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzanJ = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzanK = Application.zzcQ(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzx.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzanL = streamName;
            return this;
        }

        public DataSource build() {
            zzx.zza((this.zzanl != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzx.zza((this.zzUS >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

